/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.switchyard.Context;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.internal.DefaultContext;
import org.switchyard.serial.graph.AccessType;
import org.switchyard.serial.graph.Strategy;

@Strategy(access=AccessType.FIELD)
public class CompositeContext
implements Context {
    private Map<Scope, Context> _contexts = new HashMap<Scope, Context>();

    public CompositeContext() {
        this._contexts.put(Scope.EXCHANGE, new DefaultContext(Scope.EXCHANGE));
        this._contexts.put(Scope.MESSAGE, new DefaultContext(Scope.MESSAGE));
    }

    public void setContext(Scope scope, Context context) {
        this._contexts.put(scope, context);
    }

    public void mergeInto(Context context) {
        for (Map.Entry<Scope, Context> entry : this._contexts.entrySet()) {
            entry.getValue().mergeInto(context);
        }
    }

    public Property getProperty(String name) {
        Property property = this.getProperty(name, Scope.MESSAGE);
        return property == null ? this.getProperty(name, Scope.EXCHANGE) : property;
    }

    public Property getProperty(String name, Scope scope) {
        if (!this._contexts.containsKey(scope)) {
            return null;
        }
        return this._contexts.get(scope).getProperty(name);
    }

    public <T> T getPropertyValue(String name) {
        Property property = this.getProperty(name);
        return (T)(property == null ? null : property.getValue());
    }

    public Set<Property> getProperties() {
        HashSet<Property> properties = new HashSet<Property>();
        for (Context ctx : this._contexts.values()) {
            properties.addAll(ctx.getProperties());
        }
        return properties;
    }

    public Set<Property> getProperties(Scope scope) {
        if (this._contexts.containsKey(scope)) {
            return this._contexts.get(scope).getProperties();
        }
        return null;
    }

    public Set<Property> getProperties(String label) {
        HashSet<Property> properties = new HashSet<Property>();
        for (Context ctx : this._contexts.values()) {
            properties.addAll(ctx.getProperties(label));
        }
        return properties;
    }

    public void removeProperty(Property property) {
        for (Map.Entry<Scope, Context> entry : this._contexts.entrySet()) {
            if (entry.getKey() != property.getScope()) continue;
            entry.getValue().removeProperty(property);
        }
    }

    public void removeProperties() {
        for (Context ctx : this._contexts.values()) {
            ctx.removeProperties();
        }
    }

    public void removeProperties(Scope scope) {
        if (this._contexts.containsKey(scope)) {
            this._contexts.get(scope).removeProperties();
        }
    }

    public void removeProperties(String label) {
        for (Context ctx : this._contexts.values()) {
            ctx.removeProperties(label);
        }
    }

    public Property setProperty(String name, Object val) {
        return this.setProperty(name, val, Scope.MESSAGE);
    }

    public Property setProperty(String name, Object val, Scope scope) {
        if (this._contexts.containsKey(scope)) {
            return this._contexts.get(scope).setProperty(name, val);
        }
        throw new IllegalArgumentException(scope.name());
    }

    public Context setProperties(Set<Property> properties) {
        for (Property property : properties) {
            this.setProperty(property.getName(), property.getValue(), property.getScope());
        }
        return this;
    }
}

