/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.transform.camel.internal;

import javax.xml.namespace.QName;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.switchyard.ServiceDomain;
import org.switchyard.transform.Transformer;
import org.switchyard.transform.camel.internal.CamelTransformer;
import org.switchyard.transform.config.model.CamelTransformModel;
import org.switchyard.transform.internal.TransformMessages;
import org.switchyard.transform.internal.TransformerFactory;

public class CamelTransformFactory
implements TransformerFactory<CamelTransformModel> {
    @Override
    public Transformer<?, ?> newTransformer(ServiceDomain domain, CamelTransformModel model) {
        QName from = model.getFrom();
        QName to = model.getTo();
        String uri = model.getEndpointUri();
        CamelContext camelContext = (CamelContext)domain.getProperty("CamelContextProperty");
        Endpoint endpoint = camelContext.getEndpoint(uri);
        if (endpoint == null) {
            throw TransformMessages.MESSAGES.camelEndpointNotFound(uri);
        }
        return new CamelTransformer(from, to, endpoint);
    }
}

