/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.common.camel;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.ManagementStatisticsLevel;
import org.apache.camel.spring.CamelContextFactoryBean;
import org.jboss.logging.Logger;
import org.switchyard.ServiceDomain;
import org.switchyard.common.camel.CamelModelFactory;
import org.switchyard.common.camel.CommonCamelLogger;
import org.switchyard.common.camel.SwitchYardCamelContext;
import org.switchyard.common.type.Classes;

public final class CamelContextConfigurator {
    private static final Logger LOG = Logger.getLogger(CamelContextConfigurator.class);
    public static final String SHUTDOWN_TIMEOUT = "org.switchyard.camel.ShutdownTimeout";
    public static final String PERFORMANCE_STATISTICS = "org.switchyard.camel.PerformanceStatistics";
    public static final String MDC_LOGGING_ENABLED = "org.switchyard.camel.useMDCLogging";
    public static final String CAMEL_CONTEXT_CONFIG = "org.switchyard.camel.CamelContextConfiguration";
    public static final String CAMEL_CONTEXT_CONFIG_XML = "org.switchyard.camel.CamelContextConfigurationXML";

    private CamelContextConfigurator() {
    }

    public static final void configure(CamelContext context, ServiceDomain domain) {
        CamelContextConfigurator.configure(context, domain.getProperties());
    }

    public static final void configure(CamelContext context, Map<String, Object> properties) {
        for (Map.Entry<String, Object> property : properties.entrySet()) {
            if (property.getValue() == null) continue;
            CamelContextConfigurator.configure(context, property.getKey(), property.getValue());
        }
    }

    public static final void configure(CamelContext context, String name, Object value) {
        block11: {
            try {
                if (name.equals(SHUTDOWN_TIMEOUT)) {
                    CamelContextConfigurator.configureShutdownTimeout(context, value);
                } else if (name.equals(PERFORMANCE_STATISTICS)) {
                    CamelContextConfigurator.configurePerformanceStatistics(context, value);
                } else if (name.equals(CAMEL_CONTEXT_CONFIG)) {
                    CamelContextConfigurator.configureCamelContextAware(context, value);
                } else if (name.equals(MDC_LOGGING_ENABLED)) {
                    CamelContextConfigurator.configureMDCLogging(context, value);
                } else if (name.equals(CAMEL_CONTEXT_CONFIG_XML)) {
                    CamelContextConfigurator.configureCamelContextXML(context, value);
                }
            }
            catch (Exception ex) {
                CommonCamelLogger.ROOT_LOGGER.camelContextConfigurationError(name, value, ex);
                if (!LOG.isDebugEnabled()) break block11;
                LOG.debug(null, (Throwable)ex);
            }
        }
    }

    private static void configureMDCLogging(CamelContext context, Object value) {
        boolean enabled = Boolean.parseBoolean(value.toString());
        context.setUseMDCLogging(Boolean.valueOf(enabled));
    }

    private static void configureShutdownTimeout(CamelContext context, Object value) {
        int timeout = Integer.parseInt(value.toString());
        context.getShutdownStrategy().setTimeout((long)timeout);
    }

    private static void configurePerformanceStatistics(CamelContext context, Object value) {
        ManagementStatisticsLevel level = ManagementStatisticsLevel.valueOf((String)value.toString());
        context.getManagementStrategy().setStatisticsLevel(level);
    }

    private static void configureCamelContextAware(CamelContext context, Object value) throws Exception {
        Class contextAwareClass = Classes.forName((String)value.toString());
        CamelContextAware contextAware = (CamelContextAware)contextAwareClass.newInstance();
        contextAware.setCamelContext(context);
    }

    private static void configureCamelContextXML(CamelContext context, Object value) throws Exception {
        Object object = CamelModelFactory.createCamelModelObjectFromXML(value.toString());
        if (object instanceof CamelContextFactoryBean) {
            CamelModelFactory.importCamelContextFactoryBean((SwitchYardCamelContext)context, (CamelContextFactoryBean)object);
        }
    }
}

