/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.resteasy.osgi;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.osgi.service.http.HttpService;
import org.switchyard.ServiceDomain;
import org.switchyard.common.type.Classes;
import org.switchyard.component.common.Endpoint;
import org.switchyard.component.resteasy.osgi.OsgiRESTEasyResource;
import org.switchyard.component.resteasy.osgi.OsgiRESTEasyServletRegistry;
import org.switchyard.component.resteasy.osgi.OsgiRESTEasyServletWrapper;
import org.switchyard.component.resteasy.osgi.RESTEasyProviders;
import org.switchyard.component.resteasy.resource.ResourcePublisher;
import org.switchyard.component.resteasy.util.RESTEasyUtil;

public class OsgiRESTEasyResourcePublisher
implements ResourcePublisher {
    private static final String KEY_SERVLET_REGISTRY = "org.switchyard.deploy.osgi.internal.resteasy.RESTEasyServletRegistry";
    private static final String KEY_SERVLET_MAPPING_PREFIX = "resteasy.servlet.mapping.prefix";
    private static final Logger LOGGER = Logger.getLogger(OsgiRESTEasyResourcePublisher.class);
    private HttpService _httpService;

    public void setHttpService(HttpService httpService) {
        this._httpService = httpService;
    }

    @Override
    public Endpoint publish(ServiceDomain domain, String context, List<Object> instances, Map<String, String> contextParams) throws Exception {
        String alias;
        OsgiRESTEasyServletWrapper servlet;
        OsgiRESTEasyServletRegistry servletRegistry = (OsgiRESTEasyServletRegistry)domain.getProperty(KEY_SERVLET_REGISTRY);
        if (servletRegistry == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Creating OsgiRESTEasyServletRegistry");
            }
            servletRegistry = new OsgiRESTEasyServletRegistry().setOsgiHttpService(this._httpService);
            domain.setProperty(KEY_SERVLET_REGISTRY, (Object)servletRegistry);
        }
        if ((servlet = servletRegistry.getRegisteredRESTEasyServlet(alias = context.startsWith("/") ? context : "/" + context)) == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Registering RESTEasy servlet with an alias '" + alias + "'"));
            }
            servlet = new OsgiRESTEasyServletWrapper().setClassLoader(Classes.getTCCL());
            Hashtable<String, String> initparams = new Hashtable<String, String>();
            ((Dictionary)initparams).put(KEY_SERVLET_MAPPING_PREFIX, alias);
            if (contextParams != null) {
                for (Map.Entry<String, String> cp : contextParams.entrySet()) {
                    if (cp.getKey().equals("resteasy.providers")) continue;
                    ((Dictionary)initparams).put(cp.getKey(), cp.getValue());
                }
            }
            servletRegistry.registerRESTEasyServlet(alias, servlet, initparams, null);
            ResteasyProviderFactory repFactory = servlet.getDispatcher().getProviderFactory();
            for (Class<?> provider : RESTEasyProviders.PROVIDERS) {
                repFactory.registerProvider(provider);
            }
            List<Class<?>> providerClasses = RESTEasyUtil.getProviderClasses(contextParams);
            if (providerClasses != null) {
                for (Class<?> pc : providerClasses) {
                    repFactory.registerProvider(pc);
                }
            }
        }
        List<Class<?>> resourceClasses = servletRegistry.registerRESTEasyResources(alias, instances);
        return new OsgiRESTEasyResource().setServletRegistry(servletRegistry).setAlias(alias).setResourceClasses(resourceClasses);
    }
}

