/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.dao.jpa.bpel;

import java.util.ArrayList;
import java.util.Collection;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.ode.dao.bpel.ScopeDAO;
import org.apache.ode.dao.bpel.XmlDataDAO;
import org.apache.ode.dao.jpa.bpel.ScopeDAOImpl;
import org.apache.ode.dao.jpa.bpel.XmlDataProperty;
import org.apache.ode.utils.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

@Entity
@Table(name="BPEL_XML_DATA")
@NamedQueries(value={@NamedQuery(name="SELECT_XMLDATA_IDS_BY_PROCESS", query="select distinct x._id from XmlDataDAOImpl as x where x._scope._processInstance._process = :process"), @NamedQuery(name="SELECT_XMLDATA_IDS_BY_INSTANCE", query="select distinct x._id from XmlDataDAOImpl as x where x._scope._processInstance = :instance"), @NamedQuery(name="DELETE_XMLDATA_BY_SCOPE_IDS", query="delete from XmlDataDAOImpl as x where x._scopeId in(:scopeIds)")})
public class XmlDataDAOImpl
implements XmlDataDAO {
    public static final String SELECT_XMLDATA_IDS_BY_PROCESS = "SELECT_XMLDATA_IDS_BY_PROCESS";
    public static final String SELECT_XMLDATA_IDS_BY_INSTANCE = "SELECT_XMLDATA_IDS_BY_INSTANCE";
    public static final String DELETE_XMLDATA_BY_SCOPE_IDS = "DELETE_XMLDATA_BY_SCOPE_IDS";
    @Id
    @Column(name="XML_DATA_ID")
    @GeneratedValue(strategy=GenerationType.AUTO)
    private Long _id;
    @Lob
    @Column(name="DATA")
    private String _data;
    @Transient
    private Node _node;
    @Basic
    @Column(name="IS_SIMPLE_TYPE")
    private boolean _isSimpleType;
    @Basic
    @Column(name="NAME")
    private String _name;
    @OneToMany(targetEntity=XmlDataProperty.class, mappedBy="_xmlData", fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    private Collection<XmlDataProperty> _props = new ArrayList<XmlDataProperty>();
    @Basic
    @Column(name="SCOPE_ID", nullable=true, insertable=false, updatable=false)
    private Long _scopeId;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST})
    @JoinColumn(name="SCOPE_ID")
    private ScopeDAOImpl _scope;

    public XmlDataDAOImpl() {
    }

    public XmlDataDAOImpl(ScopeDAOImpl scope, String name) {
        this._scope = scope;
        this._name = name;
    }

    public Node get() {
        if (this._node == null && this._data != null) {
            if (this._isSimpleType) {
                Document d = DOMUtils.newDocument();
                Element e = d.createElement("text-node-wrapper");
                Text tnode = d.createTextNode(this._data);
                d.appendChild(e);
                e.appendChild(tnode);
                this._node = tnode;
            } else {
                try {
                    this._node = DOMUtils.stringToDOM((String)this._data);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return this._node;
    }

    public String getName() {
        return this._name;
    }

    public String getProperty(String propertyName) {
        for (XmlDataProperty prop : this._props) {
            if (!prop.getPropertyKey().equals(propertyName)) continue;
            return prop.getPropertyValue();
        }
        return null;
    }

    private XmlDataProperty getPropertyObject(String propertyName) {
        for (XmlDataProperty prop : this._props) {
            if (!prop.getPropertyKey().equals(propertyName)) continue;
            return prop;
        }
        return null;
    }

    public ScopeDAO getScopeDAO() {
        return this._scope;
    }

    public boolean isNull() {
        return this._data == null;
    }

    public void remove() {
    }

    public void set(Node val) {
        this._node = val;
        if (val instanceof Element) {
            this._isSimpleType = false;
            this._data = DOMUtils.domToString((Node)val);
        } else if (this._node != null) {
            this._isSimpleType = true;
            this._data = this._node.getNodeValue();
        }
    }

    public void setProperty(String pname, String pvalue) {
        XmlDataProperty prop = this.getPropertyObject(pname);
        if (prop == null) {
            this._props.add(new XmlDataProperty(pname, pvalue, this));
        } else {
            prop.setPropertyValue(pvalue);
        }
    }

    @Deprecated
    public Long get_id() {
        return this._id;
    }

    @Deprecated
    public void set_id(Long id) {
        this._id = id;
    }
}

