/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty;

import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelException;
import org.apache.camel.Suspendable;
import org.apache.camel.component.netty.NettyClientBossPoolBuilder;
import org.apache.camel.component.netty.NettyConsumer;
import org.apache.camel.component.netty.NettyServerBootstrapConfiguration;
import org.apache.camel.component.netty.NettyServerBootstrapFactory;
import org.apache.camel.component.netty.NettyWorkerPoolBuilder;
import org.apache.camel.support.ServiceSupport;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.socket.nio.BossPool;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.WorkerPool;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientModeTCPNettyServerBootstrapFactory
extends ServiceSupport
implements NettyServerBootstrapFactory,
Suspendable {
    protected static final Logger LOG = LoggerFactory.getLogger(ClientModeTCPNettyServerBootstrapFactory.class);
    private CamelContext camelContext;
    private ThreadFactory threadFactory;
    private NettyServerBootstrapConfiguration configuration;
    private ChannelPipelineFactory pipelineFactory;
    private ChannelFactory channelFactory;
    private ClientBootstrap serverBootstrap;
    private Channel channel;
    private BossPool bossPool;
    private WorkerPool workerPool;

    @Override
    public void init(CamelContext camelContext, NettyServerBootstrapConfiguration configuration, ChannelPipelineFactory pipelineFactory) {
        this.camelContext = camelContext;
        this.configuration = configuration;
        this.pipelineFactory = pipelineFactory;
    }

    @Override
    public void init(ThreadFactory threadFactory, NettyServerBootstrapConfiguration configuration, ChannelPipelineFactory pipelineFactory) {
        this.threadFactory = threadFactory;
        this.configuration = configuration;
        this.pipelineFactory = pipelineFactory;
    }

    @Override
    public void addChannel(Channel channel) {
    }

    @Override
    public void removeChannel(Channel channel) {
    }

    @Override
    public void addConsumer(NettyConsumer consumer) {
    }

    @Override
    public void removeConsumer(NettyConsumer consumer) {
    }

    protected void doStart() throws Exception {
        if (this.camelContext == null && this.threadFactory == null) {
            throw new IllegalArgumentException("Either CamelContext or ThreadFactory must be set on " + this);
        }
        this.startServerBootstrap();
    }

    protected void doStop() throws Exception {
        this.stopServerBootstrap();
    }

    protected void doResume() throws Exception {
        ChannelFuture connectFuture = this.serverBootstrap.connect((SocketAddress)new InetSocketAddress(this.configuration.getHost(), this.configuration.getPort()));
        this.channel = this.openChannel(connectFuture);
    }

    protected void doSuspend() throws Exception {
        if (this.channel != null) {
            LOG.debug("ServerBootstrap disconnecting from {}:{}", (Object)this.configuration.getHost(), (Object)this.configuration.getPort());
            this.channel.disconnect().sync();
            this.channel = null;
        }
    }

    protected void startServerBootstrap() {
        BossPool bp = this.configuration.getBossPool();
        WorkerPool wp = this.configuration.getWorkerPool();
        if (bp == null) {
            bp = this.bossPool = new NettyClientBossPoolBuilder().withTimer((Timer)new HashedWheelTimer()).withBossCount(this.configuration.getBossCount()).withName("NettyClientTCPBoss").build();
        }
        if (wp == null) {
            wp = this.workerPool = new NettyWorkerPoolBuilder().withWorkerCount(this.configuration.getWorkerCount()).withName("NettyServerTCPWorker").build();
        }
        this.channelFactory = new NioClientSocketChannelFactory(bp, wp);
        this.serverBootstrap = new ClientBootstrap(this.channelFactory);
        this.serverBootstrap.setOption("keepAlive", (Object)this.configuration.isKeepAlive());
        this.serverBootstrap.setOption("tcpNoDelay", (Object)this.configuration.isTcpNoDelay());
        this.serverBootstrap.setOption("reuseAddress", (Object)this.configuration.isReuseAddress());
        this.serverBootstrap.setOption("connectTimeoutMillis", (Object)this.configuration.getConnectTimeout());
        if (this.configuration.getBacklog() > 0) {
            this.serverBootstrap.setOption("backlog", (Object)this.configuration.getBacklog());
        }
        if (this.configuration.getOptions() != null) {
            for (Map.Entry<String, Object> entry : this.configuration.getOptions().entrySet()) {
                this.serverBootstrap.setOption(entry.getKey(), entry.getValue());
            }
        }
        LOG.debug("Created ServerBootstrap {} with options: {}", (Object)this.serverBootstrap, (Object)this.serverBootstrap.getOptions());
        this.serverBootstrap.setPipelineFactory(this.pipelineFactory);
        LOG.info("ServerBootstrap connecting to {}:{}", (Object)this.configuration.getHost(), (Object)this.configuration.getPort());
        ChannelFuture connectFuture = this.serverBootstrap.connect((SocketAddress)new InetSocketAddress(this.configuration.getHost(), this.configuration.getPort()));
        try {
            this.channel = this.openChannel(connectFuture);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected Channel openChannel(ChannelFuture channelFuture) throws Exception {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Waiting for operation to complete {} for {} millis", (Object)channelFuture, (Object)this.configuration.getConnectTimeout());
        }
        final CountDownLatch channelLatch = new CountDownLatch(1);
        channelFuture.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture cf) throws Exception {
                channelLatch.countDown();
            }
        });
        try {
            channelLatch.await(this.configuration.getConnectTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            throw new CamelException("Interrupted while waiting for connection to " + this.configuration.getAddress());
        }
        if (!channelFuture.isDone() || !channelFuture.isSuccess()) {
            ConnectException cause = new ConnectException("Cannot connect to " + this.configuration.getAddress());
            if (channelFuture.getCause() != null) {
                cause.initCause(channelFuture.getCause());
            }
            throw cause;
        }
        Channel answer = channelFuture.getChannel();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating connector to address: {}", (Object)this.configuration.getAddress());
        }
        return answer;
    }

    protected void stopServerBootstrap() {
        LOG.info("ServerBootstrap disconnecting from {}:{}", (Object)this.configuration.getHost(), (Object)this.configuration.getPort());
        if (this.channelFactory != null) {
            this.channelFactory.releaseExternalResources();
            this.channelFactory = null;
        }
        if (this.bossPool != null) {
            this.bossPool.shutdown();
            this.bossPool = null;
        }
        if (this.workerPool != null) {
            this.workerPool.shutdown();
            this.workerPool = null;
        }
    }
}

