/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.http.composer;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.namespace.QName;
import org.switchyard.Exchange;
import org.switchyard.ExchangeState;
import org.switchyard.Message;
import org.switchyard.Property;
import org.switchyard.ServiceDomain;
import org.switchyard.ServiceReference;
import org.switchyard.common.xml.QNameUtil;
import org.switchyard.component.common.composer.BaseMessageComposer;
import org.switchyard.component.common.composer.BindingData;
import org.switchyard.component.common.label.EndpointLabel;
import org.switchyard.component.http.composer.HttpBindingData;
import org.switchyard.component.http.composer.HttpResponseBindingData;
import org.switchyard.config.model.composer.MessageComposerModel;
import org.switchyard.metadata.JavaTypes;
import org.switchyard.transform.Transformer;
import org.switchyard.transform.TransformerRegistry;

public class HttpMessageComposer
extends BaseMessageComposer<HttpBindingData> {
    private MessageComposerModel _config;
    public static final String CAMEL_HTTP_HEADER = "CamelHttp";
    private static final String SERVICE_REFERENCE_PROPERTY = "org.switchyard.bus.camel.consumer";

    public Message compose(HttpBindingData source, Exchange exchange) throws Exception {
        Message message = exchange.createMessage();
        this.getContextMapper().mapFrom((BindingData)source, exchange.getContext(message));
        QName msgType = HttpMessageComposer.getMessageType((Exchange)exchange);
        message.setContent((Object)source.getBody());
        if (msgType != null && QNameUtil.isJavaMessageType((QName)msgType)) {
            message.setContent(message.getContent(QNameUtil.toJavaMessageType((QName)msgType)));
        }
        return message;
    }

    public HttpBindingData decompose(Exchange exchange, HttpBindingData target) throws Exception {
        Message message = exchange.getMessage();
        if (message != null) {
            Property responseCode;
            Object content = message.getContent();
            if (target instanceof HttpResponseBindingData && ((responseCode = exchange.getContext().getProperty("http_response_status")) == null || !responseCode.hasLabel(EndpointLabel.HTTP.label()))) {
                int status = 202;
                if (exchange.getState() == ExchangeState.FAULT) {
                    status = 500;
                } else if (content == null) {
                    status = 204;
                } else if (content instanceof HttpResponseBindingData) {
                    status = ((HttpResponseBindingData)content).getStatus();
                } else if (content instanceof String || content instanceof byte[] || content instanceof InputStream || content instanceof Reader) {
                    status = 200;
                } else if (exchange.getContext().getProperty(SERVICE_REFERENCE_PROPERTY) != null) {
                    QName to;
                    QName from;
                    ServiceDomain domain = ((ServiceReference)exchange.getContext().getProperty(SERVICE_REFERENCE_PROPERTY).getValue()).getDomain();
                    TransformerRegistry registry = domain.getTransformerRegistry();
                    Transformer transformer = registry.getTransformer(from = JavaTypes.toMessageType(content.getClass()), to = JavaTypes.toMessageType(String.class));
                    if (transformer != null) {
                        Object stringForm = transformer.transform(content);
                        content = (String)stringForm;
                        status = 200;
                    }
                } else {
                    status = 502;
                }
                HttpResponseBindingData response = (HttpResponseBindingData)target;
                response.setStatus(status);
            }
            this.setContent(content, target);
        }
        this.getContextMapper().mapTo(exchange.getContext(), (BindingData)target);
        return target;
    }

    private void setContent(Object content, HttpBindingData message) throws IOException {
        if (content == null) {
            message.setBodyBytes(null);
        } else if (content instanceof String) {
            message.setBody((String)content);
        } else if (content instanceof byte[]) {
            message.setBodyBytes((byte[])content);
        } else if (content instanceof InputStream) {
            message.setBodyFromStream((InputStream)content);
        } else if (content instanceof Reader) {
            message.setBodyFromReader((Reader)content);
        } else {
            message.setBody("" + content);
        }
    }

    public MessageComposerModel getComposerConfig() {
        return this._config;
    }

    public void setComposerConfig(MessageComposerModel composerConfig) {
        this._config = composerConfig;
    }
}

