/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.jca.composer;

import java.util.ArrayList;
import java.util.Enumeration;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import org.switchyard.Context;
import org.switchyard.Property;
import org.switchyard.component.common.composer.BaseRegexContextMapper;
import org.switchyard.component.common.composer.BindingData;
import org.switchyard.component.common.label.ComponentLabel;
import org.switchyard.component.common.label.EndpointLabel;
import org.switchyard.component.common.label.PropertyLabel;
import org.switchyard.component.jca.composer.JMSBindingData;

public class JMSContextMapper
extends BaseRegexContextMapper<JMSBindingData> {
    public static final String HEADER_JMS_DESTINATION = "javax.jms.JMSDestination";
    public static final String HEADER_JMS_DELIVERY_MODE = "javax.jms.JMSDeliveryMode";
    public static final String HEADER_JMS_MESSAGE_ID = "javax.jms.JMSMessageID";
    public static final String HEADER_JMS_TIMESTAMP = "javax.jms.JMSTimestamp";
    public static final String HEADER_JMS_CORRELATION_ID = "javax.jms.JMSCorrelationID";
    public static final String HEADER_JMS_REPLY_TO = "javax.jms.JMSReplyTo";
    public static final String HEADER_JMS_REDELIVERED = "javax.jms.JMSRedelivered";
    public static final String HEADER_JMS_TYPE = "javax.jms.JMSType";
    public static final String HEADER_JMS_EXPIRATION = "javax.jms.JMSExpiration";
    public static final String HEADER_JMS_PRIORITY = "javax.jms.JMSPriority";
    private static final String[] JMS_HEADER_LABELS = new String[]{ComponentLabel.JCA.label(), EndpointLabel.JMS.label(), PropertyLabel.HEADER.label()};
    private static final String[] JMS_PROPERTY_LABELS = new String[]{ComponentLabel.JCA.label(), EndpointLabel.JMS.label(), PropertyLabel.PROPERTY.label()};

    public void mapFrom(JMSBindingData source, Context context) throws Exception {
        super.mapFrom((BindingData)source, context);
        Message message = source.getMessage();
        if (this.matches(HEADER_JMS_DESTINATION)) {
            context.setProperty(HEADER_JMS_DESTINATION, (Object)message.getJMSDestination()).addLabels(JMS_HEADER_LABELS);
        }
        if (this.matches(HEADER_JMS_DELIVERY_MODE)) {
            context.setProperty(HEADER_JMS_DELIVERY_MODE, (Object)message.getJMSDeliveryMode()).addLabels(JMS_HEADER_LABELS);
        }
        if (this.matches(HEADER_JMS_EXPIRATION)) {
            context.setProperty(HEADER_JMS_EXPIRATION, (Object)message.getJMSExpiration()).addLabels(JMS_HEADER_LABELS);
        }
        if (this.matches(HEADER_JMS_PRIORITY)) {
            context.setProperty(HEADER_JMS_PRIORITY, (Object)message.getJMSPriority()).addLabels(JMS_HEADER_LABELS);
        }
        if (this.matches(HEADER_JMS_MESSAGE_ID)) {
            context.setProperty(HEADER_JMS_MESSAGE_ID, (Object)message.getJMSMessageID()).addLabels(JMS_HEADER_LABELS);
        }
        if (this.matches(HEADER_JMS_TIMESTAMP)) {
            context.setProperty(HEADER_JMS_TIMESTAMP, (Object)message.getJMSTimestamp()).addLabels(JMS_HEADER_LABELS);
        }
        if (this.matches(HEADER_JMS_CORRELATION_ID)) {
            context.setProperty(HEADER_JMS_CORRELATION_ID, (Object)message.getJMSCorrelationID()).addLabels(JMS_HEADER_LABELS);
        }
        if (this.matches(HEADER_JMS_REPLY_TO)) {
            context.setProperty(HEADER_JMS_REPLY_TO, (Object)message.getJMSReplyTo()).addLabels(JMS_HEADER_LABELS);
        }
        if (this.matches(HEADER_JMS_TYPE)) {
            context.setProperty(HEADER_JMS_TYPE, (Object)message.getJMSType()).addLabels(JMS_HEADER_LABELS);
        }
        if (this.matches(HEADER_JMS_REDELIVERED)) {
            context.setProperty(HEADER_JMS_REDELIVERED, (Object)message.getJMSRedelivered()).addLabels(JMS_HEADER_LABELS);
        }
        Enumeration e = message.getPropertyNames();
        while (e.hasMoreElements()) {
            Object value;
            String key = e.nextElement().toString();
            if (this.matches(key)) {
                value = null;
                try {
                    value = message.getObjectProperty(key);
                }
                catch (JMSException pce) {
                    pce.getMessage();
                }
                if (value == null) continue;
                context.setProperty(key, value).addLabels(JMS_PROPERTY_LABELS);
                continue;
            }
            if (!this.matches(key, this.getIncludeRegexes(), new ArrayList())) continue;
            value = null;
            try {
                value = message.getObjectProperty(key);
            }
            catch (JMSException pce) {
                pce.getMessage();
            }
            if (value == null) continue;
            context.setProperty(key, value).addLabels(JMS_PROPERTY_LABELS);
        }
    }

    public void mapTo(Context context, JMSBindingData target) throws Exception {
        super.mapTo(context, (BindingData)target);
        Message message = target.getMessage();
        for (Property property : context.getProperties()) {
            Object value;
            String name = property.getName();
            if (this.matches(name)) {
                value = property.getValue();
                if (value == null) continue;
                try {
                    if (name.equals(HEADER_JMS_DESTINATION)) {
                        message.setJMSDestination((Destination)Destination.class.cast(value));
                        continue;
                    }
                    if (name.equals(HEADER_JMS_DELIVERY_MODE)) {
                        message.setJMSDeliveryMode(Integer.parseInt(value.toString()));
                        continue;
                    }
                    if (name.equals(HEADER_JMS_EXPIRATION)) {
                        message.setJMSExpiration(Long.parseLong(value.toString()));
                        continue;
                    }
                    if (name.equals(HEADER_JMS_PRIORITY)) {
                        message.setJMSPriority(Integer.parseInt(value.toString()));
                        continue;
                    }
                    if (name.equals(HEADER_JMS_MESSAGE_ID)) {
                        message.setJMSMessageID(value.toString());
                        continue;
                    }
                    if (name.equals(HEADER_JMS_TIMESTAMP)) {
                        message.setJMSTimestamp(Long.parseLong(value.toString()));
                        continue;
                    }
                    if (name.equals(HEADER_JMS_CORRELATION_ID)) {
                        message.setJMSCorrelationID(value.toString());
                        continue;
                    }
                    if (name.equals(HEADER_JMS_REPLY_TO)) {
                        message.setJMSReplyTo((Destination)Destination.class.cast(value));
                        continue;
                    }
                    if (name.equals(HEADER_JMS_TYPE)) {
                        message.setJMSType(value.toString());
                        continue;
                    }
                    if (name.equals(HEADER_JMS_REDELIVERED)) {
                        message.setJMSRedelivered(Boolean.parseBoolean(value.toString()));
                        continue;
                    }
                    message.setObjectProperty(name, value);
                }
                catch (Throwable t) {}
                continue;
            }
            if (!this.matches(name, this.getIncludeRegexes(), new ArrayList()) || (value = property.getValue()) == null) continue;
            message.setObjectProperty(name, value);
        }
    }
}

