/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.runtime;

import org.jboss.logging.Messages;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageBundle;
import org.switchyard.HandlerException;
import org.switchyard.SwitchYardException;
import org.switchyard.TransactionFailureException;

@MessageBundle(projectCode="SWITCHYARD")
public interface RuntimeMessages {
    public static final RuntimeMessages MESSAGES = (RuntimeMessages)Messages.getBundle(RuntimeMessages.class);

    @Message(id=14000, value="Validator:[class=%s', type='%s', name='%s'] failed: %s")
    public String validatorFailed(String var1, String var2, String var3, String var4);

    @Message(id=14001, value="TransactionHandler failed to complete a transaction")
    public TransactionFailureException failedToCompleteTransaction(@Cause Exception var1);

    @Message(id=14002, value="Invalid transaction policy : %s and %s cannot be requested simultaneously.")
    public TransactionFailureException invalidTransactionPolicy(String var1, String var2);

    @Message(id=14003, value="Invalid transaction policy : %s cannot be requested with %s nor %s")
    public TransactionFailureException invalidTransactionPolicyCombo(String var1, String var2, String var3);

    @Message(id=14004, value="Invalid transaction status : %s is required but the transaction doesn't exist")
    public TransactionFailureException noTransactionPropagated(String var1);

    @Message(id=14005, value="Failed to create new transaction")
    public TransactionFailureException failedCreateNewTransaction(@Cause Exception var1);

    @Message(id=14006, value="Transaction already exists")
    public TransactionFailureException transactionAlreadyExists();

    @Message(id=14007, value="Failed to rollback transaction")
    public TransactionFailureException failedToRollbackTransaction(@Cause Exception var1);

    @Message(id=14008, value="Failed to commit transaction")
    public TransactionFailureException failedToCommitTransaction(@Cause Exception var1);

    @Message(id=14009, value="Failed to complete transaction due to invalid status - code=%d: see javax.transaction.Status.")
    public TransactionFailureException failedToCompleteWithStatus(int var1);

    @Message(id=14010, value="Failed to retrieve transaction status")
    public TransactionFailureException failedToRetrieveStatus(@Cause Exception var1);

    @Message(id=14011, value="Transformations not applied.  Required payload type of '%s'.  Actual payload type is '%s'.  You must define and register a Transformer to transform between these types.")
    public String transformationsNotApplied(String var1, String var2);

    @Message(id=14012, value="No registered service found for %s")
    public SwitchYardException noRegisteredService(String var1);

    @Message(id=14013, value="Operation %s is not included in interface for service: %s")
    public HandlerException operationNotIncluded(String var1, String var2);

    @Message(id=14014, value="Required policies have not been provided: %s")
    public String requiredPolicesNeeded(String var1);

    @Message(id=14015, value="Multiple possible fallback validators available:")
    public String multipleFallbackValidatorsAvailable();

    @Message(id=14016, value="Multiple possible fallback transformers available:")
    public String multipleFallbackRegistry();

    @Message(id=14017, value="Send fault not allowed on new exchanges")
    public IllegalStateException sendFaultNotAllowed();

    @Message(id=14018, value="Send message not allowed for exchange in phase %s")
    public IllegalStateException sendMessageNotAllowed(String var1);

    @Message(id=14019, value="Invalid null 'message' argument in method call.")
    public IllegalArgumentException invalidMessageArgument();

    @Message(id=14020, value="Exchange instance is in a FAULT state.")
    public IllegalStateException exchangeInFaultState();

    @Message(id=14021, value="Cannot change consumer metadata after message has been sent on exchange.")
    public IllegalStateException cannotChangeMetaDataAfterMessageSent();

    @Message(id=14022, value="Invalid consumer contract - IN_OUT exchanges require a reply handler.")
    public SwitchYardException invalidConsumerContract();

    @Message(id=14023, value="Cannot change provider metadata after provider has been invoked!")
    public IllegalStateException cannotChangeMetadataAfterInvoke();

    @Message(id=14024, value="Null 'type' argument.")
    public IllegalArgumentException nullTypeArgument();

    @Message(id=14025, value="Cannot convert from '%s' to '%s'.  No TransformRegistry available.")
    public SwitchYardException noTransformRegistryAvailable(String var1, String var2);

    @Message(id=14026, value="Cannot convert from '%s' to '%s'.  No registered Transformer available for transforming from '%s' to '%s'.  A Transformer must be registered.")
    public SwitchYardException noRegisteredTransformer(String var1, String var2, String var3, String var4);

    @Message(id=14027, value="Error converting from '%s' to '%s'.  Transformer '%s' returned null.")
    public SwitchYardException transformerReturnedNull(String var1, String var2, String var3);

    @Message(id=14028, value="Error converting from '%s' to '%s'.  Transformer '%s' returned incompatible type '%s'.")
    public SwitchYardException transformerReturnedIncompatibleType(String var1, String var2, String var3, String var4);

    @Message(id=14029, value="Property name and scope must not be null!")
    public IllegalArgumentException propertyNameAndScopeCannotBeNull();

    @Message(id=14030, value="No operations in interface for service: %s")
    public SwitchYardException noOperationsInInterfaceForService(String var1);

    @Message(id=14031, value="Operation name required - multiple operations on service interface: %s")
    public SwitchYardException operationNameRequiredMultipleOps(String var1);

    @Message(id=14032, value="Operation %s does not exist for service %s")
    public SwitchYardException operationDoesNotExistForService(String var1, String var2);

    @Message(id=14033, value="Invalid phase for dispatch: %s")
    public IllegalStateException invalidPhaseForDispatch(String var1);

    @Message(id=14034, value="This exchange may handle only DefaultMessage instances.")
    public IllegalStateException onlyDefaultMessageInstances();

    @Message(id=14035, value="Message may be sent only once. Use Message.copy() to re-send same payload.")
    public IllegalStateException messageOnlySentOnce();

    @Message(id=14037, value="Scope %s is different than expected %s")
    public IllegalArgumentException scopeDifferent(String var1, String var2);

    @Message(id=14038, value="Transaction has invalid status '%s' - it must be '0' (STATUS_ACTIVE) on propagation")
    public TransactionFailureException propagatedTransactionHasInvalidStatus(int var1);

    @Message(id=14039, value="Transaction was already rolled back somehow. It may be caused by the transaction timeout, or application did it before SwitchYard handled it.")
    public TransactionFailureException transactionAlreadyRolledBack();

    @Message(id=14040, value="Validator:[class=%s', type='%s', name='%s'] failed")
    public String validatorFailed(String var1, String var2, String var3, @Cause SwitchYardException var4);
}

