/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.smooks.camel.routing;

import org.milyn.assertion.AssertArgument;
import org.milyn.expression.ExecutionContextExpressionEvaluator;
import org.milyn.javabean.lifecycle.BeanContextLifecycleEvent;
import org.milyn.javabean.lifecycle.BeanContextLifecycleObserver;
import org.milyn.javabean.lifecycle.BeanLifecycle;
import org.milyn.smooks.camel.routing.BeanRouter;

public class BeanRouterObserver
implements BeanContextLifecycleObserver {
    private BeanRouter beanRouter;
    private final String beanId;
    private ExecutionContextExpressionEvaluator conditionEvaluator;

    public BeanRouterObserver(BeanRouter beanRouter, String beanId) {
        AssertArgument.isNotNull(beanRouter, "beanRouter");
        AssertArgument.isNotNull(beanId, "beanId");
        this.beanRouter = beanRouter;
        this.beanId = beanId;
    }

    public void setConditionEvaluator(ExecutionContextExpressionEvaluator conditionEvaluator) {
        this.conditionEvaluator = conditionEvaluator;
    }

    public void onBeanLifecycleEvent(BeanContextLifecycleEvent event) {
        if (this.endEventAndBeanIdMatch(event) && this.conditionsMatch(event)) {
            this.beanRouter.sendBean(event.getBean(), event.getExecutionContext());
        }
    }

    private boolean endEventAndBeanIdMatch(BeanContextLifecycleEvent event) {
        return event.getLifecycle() == BeanLifecycle.END_FRAGMENT && event.getBeanId().getName().equals(this.beanId);
    }

    public boolean conditionsMatch(BeanContextLifecycleEvent event) {
        if (this.conditionEvaluator == null) {
            return true;
        }
        try {
            return this.conditionEvaluator.eval(event.getExecutionContext());
        }
        catch (Exception e) {
            return false;
        }
    }
}

