/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.transformer;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.camel.CamelContext;
import org.apache.camel.impl.converter.BaseTypeConverterRegistry;
import org.apache.camel.impl.converter.DefaultTypeConverter;
import org.switchyard.component.camel.transformer.CamelTransformer;
import org.switchyard.config.model.transform.TransformModel;
import org.switchyard.config.model.transform.TransformsModel;
import org.switchyard.config.model.transform.v1.V1TransformsModel;
import org.switchyard.metadata.JavaTypes;
import org.switchyard.transform.TransformerRegistry;
import org.switchyard.transform.config.model.JavaTransformModel;
import org.switchyard.transform.config.model.TransformNamespace;
import org.switchyard.transform.config.model.v1.V1JavaTransformModel;

public class CamelTypeConverterExtractor
extends DefaultTypeConverter {
    private Map<QName, Set<QName>> _transformTypes = new HashMap<QName, Set<QName>>();
    private CamelContext _camelContext;

    public CamelTypeConverterExtractor(CamelContext camelContext) {
        super(camelContext.getPackageScanClassResolver(), camelContext.getInjector(), camelContext.getDefaultFactoryFinder());
        this._camelContext = camelContext;
    }

    public void init() throws Exception {
        this._camelContext.addService((Object)this);
    }

    public Map<QName, Set<QName>> getTransformTypes() {
        for (Map.Entry entry : this.typeMappings.entrySet()) {
            BaseTypeConverterRegistry.TypeMapping mapping = (BaseTypeConverterRegistry.TypeMapping)entry.getKey();
            QName fromType = JavaTypes.toMessageType((Class)mapping.getFromType());
            QName toType = JavaTypes.toMessageType((Class)mapping.getToType());
            this.getToTypesFor(fromType).add(toType);
        }
        return Collections.unmodifiableMap(this._transformTypes);
    }

    private Set<QName> getToTypesFor(QName fromType) {
        if (!this._transformTypes.containsKey(fromType)) {
            this._transformTypes.put(fromType, new HashSet());
        }
        return this._transformTypes.get(fromType);
    }

    public TransformsModel getTransformsModel(TransformerRegistry transformerRegistry) {
        V1TransformsModel transforms = new V1TransformsModel(TransformNamespace.DEFAULT.uri());
        for (Map.Entry<QName, Set<QName>> entry : this.getTransformTypes().entrySet()) {
            QName from = entry.getKey();
            Set<QName> toTypes = entry.getValue();
            for (QName to : toTypes) {
                V1JavaTransformModel transform = new V1JavaTransformModel(TransformNamespace.DEFAULT.uri());
                transform.setFrom(from);
                transform.setTo(to);
                transform.setClazz(CamelTransformer.class.getName());
                if (this.isTransformRegistred((JavaTransformModel)transform, transformerRegistry)) continue;
                transforms.addTransform((TransformModel)transform);
            }
        }
        return transforms;
    }

    private boolean isTransformRegistred(JavaTransformModel transform, TransformerRegistry transformerRegistry) {
        if (transformerRegistry == null) {
            return false;
        }
        return transformerRegistry.hasTransformer(transform.getFrom(), transform.getTo());
    }

    public TransformsModel getTransformsModel() {
        return this.getTransformsModel(null);
    }
}

