/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.composer;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.xml.namespace.QName;
import org.switchyard.Context;
import org.switchyard.ServiceDomain;
import org.switchyard.ServiceReference;
import org.switchyard.common.lang.Strings;
import org.switchyard.common.xml.XMLHelper;
import org.switchyard.component.common.CommonCommonMessages;
import org.switchyard.component.common.composer.BaseContextMapper;
import org.switchyard.component.common.composer.BindingData;
import org.switchyard.component.common.composer.ContextMapper;
import org.switchyard.component.common.composer.RegexContextMapper;

public class BaseRegexContextMapper<D extends BindingData>
extends BaseContextMapper<D>
implements RegexContextMapper<D> {
    private final List<Pattern> _includes = new ArrayList<Pattern>();
    private final List<Pattern> _excludes = new ArrayList<Pattern>();
    private final List<Pattern> _includeNamespaces = new ArrayList<Pattern>();
    private final List<Pattern> _excludeNamespaces = new ArrayList<Pattern>();
    private boolean _prefixPropagationSet = false;
    private static final String SERVICE_REFERENCE_PROPERTY = "org.switchyard.bus.camel.consumer";
    private List<Pattern> _includeRegexes = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPatternList(String regexs, List<Pattern> patternList) {
        Set regexSet = Strings.uniqueSplitTrimToNull((String)regexs, (String)",");
        ArrayList<Pattern> tmpList = new ArrayList<Pattern>();
        for (String regex : regexSet) {
            try {
                Pattern pattern = Pattern.compile(regex);
                tmpList.add(pattern);
            }
            catch (PatternSyntaxException pse) {
                throw CommonCommonMessages.MESSAGES.isNotAValidRegexPattern(regex, pse.getMessage());
            }
        }
        List<Pattern> list = patternList;
        synchronized (list) {
            patternList.clear();
            patternList.addAll(tmpList);
        }
    }

    @Override
    public ContextMapper<D> setIncludes(String includes) {
        this.setPatternList(includes, this._includes);
        return this;
    }

    @Override
    public ContextMapper<D> setExcludes(String excludes) {
        this.setPatternList(excludes, this._excludes);
        return this;
    }

    @Override
    public ContextMapper<D> setIncludeNamespaces(String includeNamespaces) {
        this.setPatternList(includeNamespaces, this._includeNamespaces);
        return this;
    }

    @Override
    public ContextMapper<D> setExcludeNamespaces(String excludeNamespaces) {
        this.setPatternList(excludeNamespaces, this._excludeNamespaces);
        return this;
    }

    @Override
    public boolean matches(String name) {
        return this.matches(XMLHelper.createQName((String)name));
    }

    @Override
    public boolean matches(QName qname) {
        return qname != null && this.matches(qname.getLocalPart(), this._includes, this._excludes) && this.matches(qname.getNamespaceURI(), this._includeNamespaces, this._excludeNamespaces);
    }

    public boolean matches(String test, List<Pattern> includes, List<Pattern> excludes) {
        boolean matches;
        boolean green = false;
        boolean red = false;
        for (Pattern include : includes) {
            if (include.matcher(test).matches()) {
                green = true;
                break;
            }
            red = true;
        }
        boolean bl = matches = green || !red;
        if (matches) {
            green = false;
            red = false;
            for (Pattern exclude : excludes) {
                if (!exclude.matcher(test).matches()) {
                    green = true;
                    break;
                }
                red = true;
            }
            matches = green || !red;
        }
        return matches;
    }

    @Override
    public void mapFrom(D source, Context context) throws Exception {
        this.setRegexPropagationList(context);
    }

    @Override
    public void mapTo(Context context, D target) throws Exception {
        this.setRegexPropagationList(context);
    }

    protected void setRegexPropagationList(Context context) {
        if (this._includeRegexes != null) {
            return;
        }
        this._includeRegexes = new ArrayList<Pattern>();
        if (!this._prefixPropagationSet) {
            ServiceDomain domain;
            if (context.getProperty(SERVICE_REFERENCE_PROPERTY) != null && (domain = ((ServiceReference)context.getProperty(SERVICE_REFERENCE_PROPERTY).getValue()).getDomain()).getProperty("org.switchyard.propagate.regex") != null) {
                String regexList = (String)domain.getProperty("org.switchyard.propagate.regex");
                this.setPatternList(regexList, this._includeRegexes);
            }
            this._prefixPropagationSet = true;
        }
        Pattern rtGovResubmissionPattern = Pattern.compile("^_rtgov_.*$");
        this._includeRegexes.add(rtGovResubmissionPattern);
    }

    protected List<Pattern> getIncludeRegexes() {
        return this._includeRegexes;
    }
}

