/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.profile;

import java.util.Iterator;
import java.util.LinkedHashMap;
import org.milyn.profile.BasicProfile;
import org.milyn.profile.Profile;
import org.milyn.profile.ProfileSet;

public class DefaultProfileSet
extends LinkedHashMap
implements ProfileSet {
    private static final long serialVersionUID = 1L;
    private String baseProfile;

    public DefaultProfileSet(String baseProfile) {
        this.baseProfile = baseProfile;
    }

    public String getBaseProfile() {
        return this.baseProfile;
    }

    public boolean isMember(String profile) {
        if (profile == null) {
            throw new IllegalArgumentException("null 'profile' arg in method call.");
        }
        if (profile.equalsIgnoreCase(this.baseProfile)) {
            return true;
        }
        return this.containsKey(profile.trim());
    }

    public void addProfile(String profile) {
        this.addProfile(new BasicProfile(profile));
    }

    public void addProfile(Profile profile) {
        if (profile == null) {
            throw new IllegalArgumentException("null 'profile' arg in method call.");
        }
        this.put(profile.getName(), profile);
    }

    public Profile getProfile(String profile) {
        return (Profile)this.get(profile);
    }

    public Iterator iterator() {
        return this.values().iterator();
    }

    protected void addProfileSet(DefaultProfileSet profileSet) {
        if (profileSet == null) {
            throw new IllegalArgumentException("null 'profileSet' arg in method call.");
        }
        this.putAll(profileSet);
    }

    public void addProfiles(String[] subProfiles) {
        if (subProfiles == null) {
            return;
        }
        for (int i = 0; i < subProfiles.length; ++i) {
            this.addProfile(new BasicProfile(subProfiles[i]));
        }
    }

    public String toString() {
        StringBuffer setDescription = new StringBuffer();
        Iterator iterator = this.keySet().iterator();
        while (iterator.hasNext()) {
            String profile = (String)iterator.next();
            setDescription.append(profile);
            if (!iterator.hasNext()) continue;
            setDescription.append(",");
        }
        return setDescription.toString();
    }

    public static DefaultProfileSet create(String baseProfile, String[] subProfiles) {
        DefaultProfileSet profileSet = new DefaultProfileSet(baseProfile);
        profileSet.addProfiles(subProfiles);
        return profileSet;
    }
}

