/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.templating.stringtemplate;

import java.util.Map;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.cdr.annotation.AppContext;
import org.milyn.cdr.annotation.Configurator;
import org.milyn.container.ApplicationContext;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.ContentHandler;
import org.milyn.delivery.ContentHandlerFactory;
import org.milyn.delivery.annotation.Resource;
import org.milyn.delivery.dom.serialize.TextSerializationUnit;
import org.milyn.delivery.ordering.Consumer;
import org.milyn.event.report.annotation.VisitAfterReport;
import org.milyn.event.report.annotation.VisitBeforeReport;
import org.milyn.templating.AbstractTemplateProcessor;
import org.w3c.dom.Element;

@Resource(type="st")
public class StringTemplateContentHandlerFactory
implements ContentHandlerFactory {
    @AppContext
    private ApplicationContext applicationContext;

    public synchronized ContentHandler create(SmooksResourceConfiguration resourceConfig) throws SmooksConfigurationException, InstantiationException {
        try {
            return Configurator.configure(new StringTemplateTemplateProcessor(), resourceConfig, this.applicationContext);
        }
        catch (SmooksConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            InstantiationException instanceException = new InstantiationException("StringTemplate ProcessingUnit resource [" + resourceConfig.getResource() + "] not loadable.  StringTemplate resource invalid.");
            instanceException.initCause(e);
            throw instanceException;
        }
    }

    @VisitBeforeReport(condition="false")
    @VisitAfterReport(summary="Applied StringTemplate Template.", detailTemplate="reporting/StringTemplateTemplateProcessor_After.html")
    private static class StringTemplateTemplateProcessor
    extends AbstractTemplateProcessor
    implements Consumer {
        private StringTemplate template;

        private StringTemplateTemplateProcessor() {
        }

        protected void loadTemplate(SmooksResourceConfiguration config) {
            String path = config.getResource();
            if (path.charAt(0) == '/') {
                path = path.substring(1);
            }
            if (path.endsWith(".st")) {
                path = path.substring(0, path.length() - 3);
            }
            StringTemplateGroup templateGroup = new StringTemplateGroup(path);
            templateGroup.setFileCharEncoding(this.getEncoding().displayName());
            this.template = templateGroup.getInstanceOf(path);
        }

        protected void visit(Element element, ExecutionContext executionContext) {
            StringTemplate thisTransTemplate = this.template.getInstanceOf();
            Map<String, Object> beans = executionContext.getBeanContext().getBeanMap();
            thisTransTemplate.setAttributes(beans);
            String templatingResult = thisTransTemplate.toString();
            Element resultNode = TextSerializationUnit.createTextElement(element, templatingResult);
            this.processTemplateAction(element, resultNode, executionContext);
        }

        public boolean consumes(Object object) {
            return this.template.getTemplate().indexOf(object.toString()) != -1;
        }
    }
}

