/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.security.crypto;

import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SealedObject;
import javax.crypto.SecretKey;
import org.switchyard.SwitchYardException;
import org.switchyard.common.io.pull.PropertiesPuller;
import org.switchyard.common.lang.Strings;
import org.switchyard.security.BaseSecurityLogger;

public final class PrivateCrypto {
    private static final String FORMAT = PrivateCrypto.class.getSimpleName() + "@%s[sealAlgorithm=%s, secretKey=%s]";
    public static final String SEAL_ALGORITHM = "sealAlgorithm";
    public static final String SEAL_KEY_SIZE = "sealKeySize";
    private String _sealAlgorithm = null;
    private SecretKey _secretKey = null;

    public PrivateCrypto(String sealAlgorithm, int sealKeySize) {
        this.init(sealAlgorithm, sealKeySize);
    }

    public PrivateCrypto(Map<String, String> map) {
        this(new PropertiesPuller().pull(map));
    }

    public PrivateCrypto(Properties properties) {
        String sealAlgorithm = Strings.trimToNull((String)properties.getProperty(SEAL_ALGORITHM));
        int sealKeySize = -1;
        String sealKeySizeProperty = Strings.trimToNull((String)properties.getProperty(SEAL_KEY_SIZE));
        if (sealKeySizeProperty != null) {
            try {
                sealKeySize = Integer.parseInt(sealKeySizeProperty);
            }
            catch (NumberFormatException nfe) {
                BaseSecurityLogger.ROOT_LOGGER.configurationNumberFormatException(SEAL_KEY_SIZE, sealKeySizeProperty, nfe);
            }
        }
        this.init(sealAlgorithm, sealKeySize);
    }

    private void init(String sealAlgorithm, int sealKeySize) {
        if (sealAlgorithm == null || sealKeySize < 1) {
            return;
        }
        this._sealAlgorithm = sealAlgorithm;
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(this._sealAlgorithm);
            keyGenerator.init(sealKeySize);
            this._secretKey = keyGenerator.generateKey();
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new SwitchYardException((Throwable)nsae);
        }
    }

    public SealedObject seal(Serializable object) {
        try {
            Cipher cipher = Cipher.getInstance(this._sealAlgorithm);
            cipher.init(1, this._secretKey);
            return new SealedObject(object, cipher);
        }
        catch (Exception e) {
            throw new SwitchYardException((Throwable)e);
        }
    }

    public Serializable unseal(SealedObject object) {
        try {
            Cipher cipher = Cipher.getInstance(this._sealAlgorithm);
            cipher.init(2, this._secretKey);
            return (Serializable)object.getObject(cipher);
        }
        catch (Exception e) {
            throw new SwitchYardException((Throwable)e);
        }
    }

    public String toString() {
        return String.format(FORMAT, System.identityHashCode(this), this._sealAlgorithm, this._secretKey);
    }
}

