/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.monitor.model;

import java.util.ArrayList;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Query;
import javax.transaction.UserTransaction;
import org.jboss.bpm.monitor.model.BPAFDataSource;
import org.jboss.bpm.monitor.model.bpaf.Event;
import org.jboss.bpm.monitor.model.bpaf.State;
import org.jboss.bpm.monitor.model.metric.Timespan;

public class DefaultBPAFDataSource
implements BPAFDataSource {
    EntityManagerFactory emf;

    public DefaultBPAFDataSource(EntityManagerFactory emf) {
        this.emf = emf;
    }

    private <T> T executeCommand(SQLCommand<T> cmd) {
        EntityManager em = null;
        UserTransaction tx = null;
        boolean sucess = true;
        try {
            InitialContext ctx = new InitialContext();
            try {
                tx = (UserTransaction)ctx.lookup("UserTransaction");
            }
            catch (NameNotFoundException nnfe) {
                tx = (UserTransaction)ctx.lookup("java:jboss/UserTransaction");
            }
            tx.begin();
            em = this.emf.createEntityManager();
            T t = cmd.execute(em);
            return t;
        }
        catch (Exception e) {
            sucess = false;
            throw new RuntimeException("Failed to execute query", e);
        }
        finally {
            if (em != null) {
                try {
                    if (sucess) {
                        tx.commit();
                    } else {
                        tx.setRollbackOnly();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                em.close();
            }
        }
    }

    @Override
    public List<String> getProcessDefinitions() {
        List<String> result = this.executeCommand(new SQLCommand<List<String>>(){

            @Override
            public List<String> execute(EntityManager em) {
                Query query = em.createQuery("SELECT distinct (e.processDefinitionID) FROM Event as e");
                return query.getResultList();
            }
        });
        return result;
    }

    @Override
    public List<String> getProcessInstances(final String processDefinition) {
        List<String> result = this.executeCommand(new SQLCommand<List<String>>(){

            @Override
            public List<String> execute(EntityManager em) {
                Query query = em.createQuery("SELECT distinct (e.processInstanceID) FROM Event as e  WHERE e.processDefinitionID = :id");
                query.setParameter("id", (Object)processDefinition);
                return query.getResultList();
            }
        });
        return result;
    }

    @Override
    public List<String> getActivityDefinitions(final String processInstance) {
        List<String> result = this.executeCommand(new SQLCommand<List<String>>(){

            @Override
            public List<String> execute(EntityManager em) {
                Query query = em.createQuery("SELECT distinct (e.activityDefinitionID) FROM Event as e  WHERE e.processInstanceID = :id AND e.activityDefinitionID is not null");
                query.setParameter("id", (Object)processInstance);
                return query.getResultList();
            }
        });
        return result;
    }

    @Override
    public List<Event> getInstanceEvents(final String processDefinition, final Timespan timespan, final State completionState) {
        List<Event> result = this.executeCommand(new SQLCommand<List<Event>>(){

            @Override
            public List<Event> execute(EntityManager em) {
                Query query = em.createQuery("select e1 from Event as e1, Event as e2 where e1.processDefinitionID=e2.processDefinitionID and e1.processInstanceID=e2.processInstanceID and ((e1.eventDetails.currentState=?1 and e2.eventDetails.currentState=?2) OR (e2.eventDetails.currentState=?1 and e1.eventDetails.currentState=?2)) and e1.activityDefinitionID is null and e2.activityDefinitionID is null and e1.processDefinitionID='" + processDefinition + "' " + "and e1.timestamp>=?3 " + "and e2.timestamp<=?4 " + "order by e1.eventID ");
                query.setParameter(1, (Object)State.Open_Running);
                query.setParameter(2, (Object)completionState);
                query.setParameter(3, (Object)timespan.getStart());
                query.setParameter(4, (Object)timespan.getEnd());
                return query.getResultList();
            }
        });
        return result;
    }

    @Override
    public List<String> getProcessInstances(final String processDefinition, final Timespan timespan, final State completionState, final String correlationKey, final int startpos, final int maxnum) {
        List<String> result = this.executeCommand(new SQLCommand<List<String>>(){

            @Override
            public List<String> execute(EntityManager em) {
                ArrayList<String> ret = new ArrayList<String>();
                Query query = null;
                if (correlationKey == null) {
                    query = em.createQuery("select e1 from Event as e1 where e1.eventDetails.currentState=?1 and e1.activityDefinitionID is null and e1.processDefinitionID='" + processDefinition + "' " + "and e1.timestamp>=?2 " + "and e1.timestamp<=?3 " + "order by e1.timestamp");
                    query.setParameter(1, (Object)completionState);
                    query.setParameter(2, (Object)timespan.getStart());
                    query.setParameter(3, (Object)timespan.getEnd());
                } else {
                    query = em.createQuery("select e1 from Event as e1, Event as e2, IN(e1.dataElement) de where e1.processDefinitionID=e2.processDefinitionID and e1.processInstanceID=e2.processInstanceID and e2.eventDetails.currentState=?1 and e2.activityDefinitionID is null and e1.processDefinitionID='" + processDefinition + "' " + "and e1.timestamp>=?2 " + "and e1.timestamp<=?3 " + "and de.name='correlation-key' " + "and de.value='" + correlationKey + "' " + "order by e1.timestamp");
                    query.setParameter(1, (Object)completionState);
                    query.setParameter(2, (Object)timespan.getStart());
                    query.setParameter(3, (Object)timespan.getEnd());
                }
                if (maxnum > 0) {
                    query.setFirstResult(startpos);
                    query.setMaxResults(maxnum);
                }
                for (Object evt : query.getResultList()) {
                    if (!(evt instanceof Event)) continue;
                    ret.add(((Event)evt).getProcessInstanceID());
                }
                return ret;
            }
        });
        return result;
    }

    @Override
    public List<Event> getActivityCompletedEvents(final String ... processInstances) {
        List<Event> result = this.executeCommand(new SQLCommand<List<Event>>(){

            @Override
            public List<Event> execute(EntityManager em) {
                StringBuffer sb = new StringBuffer("SELECT e1 ");
                sb.append("FROM Event as e1, Event as e2 ");
                sb.append("WHERE e1.processInstanceID=e2.processInstanceID ");
                sb.append("AND ((e1.eventDetails.currentState=?1 and e2.eventDetails.currentState=?2) OR (e2.eventDetails.currentState=?1 and e1.eventDetails.currentState=?2)) ");
                sb.append("AND e1.activityDefinitionID is not null ");
                sb.append("AND e2.activityDefinitionID is not null ");
                sb.append("AND (");
                for (int i = 0; i < processInstances.length; ++i) {
                    if (i == 0) {
                        sb.append("e1.processInstanceID=\"" + processInstances[i] + "\" ");
                        continue;
                    }
                    sb.append("OR e1.processInstanceID=\"" + processInstances[i] + "\" ");
                }
                sb.append(") ");
                sb.append("GROUP BY e1.activityInstanceID ");
                sb.append("ORDER BY e1.timestamp, e1.processInstanceID");
                Query query = em.createQuery(sb.toString());
                query.setParameter(1, (Object)State.Open_Running);
                query.setParameter(2, (Object)State.Closed_Completed);
                return query.getResultList();
            }
        });
        return result;
    }

    @Override
    public List<Event> getPastActivities(final String processInstance) {
        List<Event> result = this.executeCommand(new SQLCommand<List<Event>>(){

            @Override
            public List<Event> execute(EntityManager em) {
                Query query = em.createQuery("SELECT e FROM Event as e WHERE e.processInstanceID=:id");
                query.setParameter("id", (Object)processInstance);
                return query.getResultList();
            }
        });
        return result;
    }

    @Override
    public List<String> getProcessInstances(final String processDefinition, final String propertyName, final String propertyValue) {
        List<String> result = this.executeCommand(new SQLCommand<List<String>>(){

            @Override
            public List<String> execute(EntityManager em) {
                Query query = em.createQuery("SELECT distinct e.processInstanceID FROM Event as e WHERE e.processDefinitionID = :definitionId AND e.eventID IN (SELECT d.event.eventID FROM Tuple as d WHERE d.name = :name AND d.value = :value)");
                query.setParameter("definitionId", (Object)processDefinition);
                query.setParameter("name", (Object)propertyName);
                query.setParameter("value", (Object)propertyValue);
                return query.getResultList();
            }
        });
        return result;
    }

    private static interface SQLCommand<T> {
        public T execute(EntityManager var1);
    }
}

