/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.jca.composer;

import java.util.ArrayList;
import javax.resource.cci.IndexedRecord;
import org.switchyard.Context;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.component.common.composer.BaseRegexContextMapper;
import org.switchyard.component.common.composer.BindingData;
import org.switchyard.component.common.label.ComponentLabel;
import org.switchyard.component.common.label.EndpointLabel;
import org.switchyard.component.jca.composer.IndexedRecordBindingData;

public class IndexedRecordContextMapper
extends BaseRegexContextMapper<IndexedRecordBindingData> {
    private static final String[] INDEXED_RECORD_LABELS = new String[]{ComponentLabel.JCA.label(), EndpointLabel.JCA.label()};

    public void mapFrom(IndexedRecordBindingData source, Context context) throws Exception {
        String recordDescription;
        super.mapFrom((BindingData)source, context);
        IndexedRecord record = source.getRecord();
        String recordName = record.getRecordName();
        if (recordName != null) {
            context.setProperty("recordName", (Object)recordName).addLabels(INDEXED_RECORD_LABELS);
        }
        if ((recordDescription = record.getRecordShortDescription()) != null) {
            context.setProperty("recordShortDescription", (Object)recordDescription).addLabels(INDEXED_RECORD_LABELS);
        }
        for (int i = 0; i < record.size(); ++i) {
            String[] strings;
            String element;
            Object o = record.get(i);
            if (!(o instanceof String) || !(element = (String)o).contains("=") || (strings = element.split("=")).length < 2) continue;
            String key = strings[0];
            String value = strings[1];
            if (!this.matches(key, this.getIncludeRegexes(), new ArrayList())) continue;
            context.setProperty(key, (Object)value, Scope.EXCHANGE);
        }
    }

    public void mapTo(Context context, IndexedRecordBindingData target) throws Exception {
        super.mapTo(context, (BindingData)target);
        IndexedRecord record = target.getRecord();
        for (Property property : context.getProperties()) {
            String name = property.getName();
            Object value = property.getValue();
            if (value == null) continue;
            if (name.equals("recordName")) {
                record.setRecordName(value.toString());
                continue;
            }
            if (name.equals("recordShortDescription")) {
                record.setRecordShortDescription(value.toString());
                continue;
            }
            if (this.matches(name)) {
                record.add((Object)(name + "=" + value));
                continue;
            }
            if (!this.matches(name, this.getIncludeRegexes(), new ArrayList())) continue;
            record.add((Object)(name + "=" + value));
        }
    }
}

