/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.serial.graph.node;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.switchyard.common.codec.Base64;
import org.switchyard.common.io.Buffers;
import org.switchyard.serial.graph.Graph;
import org.switchyard.serial.graph.node.Node;

public final class InputStreamNode
implements Node {
    private String _base64;

    public String getBase64() {
        return this._base64;
    }

    public void setBase64(String base64) {
        this._base64 = base64;
    }

    @Override
    public void compose(Object obj, Graph graph) {
        int bs = Buffers.DEFAULT_SIZE;
        BufferedInputStream bis = new BufferedInputStream((InputStream)obj, bs);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(bs);
        BufferedOutputStream bos = new BufferedOutputStream(baos, bs);
        byte[] buff = new byte[bs];
        int read = 0;
        try {
            while ((read = bis.read(buff)) != -1) {
                bos.write(buff, 0, read);
            }
            bos.flush();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        finally {
            try {
                bis.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.setBase64(Base64.encode((byte[])baos.toByteArray()));
    }

    @Override
    public Object decompose(Graph graph) {
        return new ByteArrayInputStream(Base64.decode((String)this.getBase64()));
    }
}

