/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.as7.extension.admin;

import javax.xml.namespace.QName;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.switchyard.admin.Application;
import org.switchyard.admin.Reference;
import org.switchyard.admin.Service;
import org.switchyard.admin.SwitchYard;
import org.switchyard.as7.extension.services.SwitchYardAdminService;

public final class SwitchYardSubsystemResetMetrics
implements OperationStepHandler {
    public static final SwitchYardSubsystemResetMetrics INSTANCE = new SwitchYardSubsystemResetMetrics();

    private SwitchYardSubsystemResetMetrics() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                block7: {
                    ServiceController controller = context.getServiceRegistry(false).getRequiredService(SwitchYardAdminService.SERVICE_NAME);
                    SwitchYard switchYard = (SwitchYard)SwitchYard.class.cast(controller.getService().getValue());
                    if (operation.hasDefined("name")) {
                        QName serviceQName = QName.valueOf(operation.get("name").asString());
                        QName applicationQName = operation.hasDefined("application-name") ? QName.valueOf(operation.get("application-name").asString()) : null;
                        block0: for (Application application : switchYard.getApplications()) {
                            if (applicationQName != null && !applicationQName.equals(application.getName())) continue;
                            for (Service service : application.getServices()) {
                                if (!serviceQName.equals(service.getName())) continue;
                                service.getPromotedService().resetMessageMetrics();
                                if (applicationQName == null) {
                                    continue block0;
                                }
                                break block7;
                            }
                            for (Reference reference : application.getReferences()) {
                                if (!serviceQName.equals(reference.getName())) continue;
                                reference.resetMessageMetrics();
                                if (applicationQName == null) {
                                    continue block0;
                                }
                                break block7;
                            }
                        }
                    } else {
                        switchYard.resetMessageMetrics();
                    }
                }
                context.stepCompleted();
            }
        }, OperationContext.Stage.RUNTIME);
        context.stepCompleted();
    }
}

