/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.test.quickstarts;

import java.util.HashMap;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.switchyard.component.test.mixins.http.HTTPMixIn;
import org.switchyard.test.ArquillianUtil;

@RunWith(value=Arquillian.class)
public class CamelCdiBusQuickstartTest {
    private static final String SOAP_REQUEST = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\">\n    <soap:Header/>    <soap:Body>\n        <orders:order xmlns:orders=\"urn:switchyard-quickstart:cdi-bus:1.0\">\n            <orderId>PO-19838-XYZ</orderId>\n            <itemId>BUTTER</itemId>\n            <quantity>200</quantity>\n        </orders:order>\n    </soap:Body>\n</soap:Envelope>";

    @Deployment(testable=false)
    public static JavaArchive createDeployment() {
        return ArquillianUtil.createJarQSDeployment((String)"switchyard-camel-bus-cdi");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeployment() throws Exception {
        HTTPMixIn httpMixIn = new HTTPMixIn();
        httpMixIn.initialize();
        try {
            XMLUnit.setIgnoreWhitespace((boolean)true);
            String response = httpMixIn.postString("http://localhost:8080/quickstart-cdi-bus/OrderService", SOAP_REQUEST);
            HashMap<String, String> namespaces = new HashMap<String, String>();
            namespaces.put("ns", "urn:switchyard-quickstart:cdi-bus:1.0");
            XMLUnit.setXpathNamespaceContext((NamespaceContext)new SimpleNamespaceContext(namespaces));
            XMLAssert.assertXpathEvaluatesTo((String)"PO-19838-XYZ", (String)"//ns:orderAck/orderId", (String)response);
            XMLAssert.assertXpathEvaluatesTo((String)"true", (String)"//ns:orderAck/accepted", (String)response);
            XMLAssert.assertXpathEvaluatesTo((String)"Order Accepted", (String)"//ns:orderAck/status", (String)response);
        }
        finally {
            httpMixIn.uninitialize();
        }
    }
}

