/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.test.quickstarts;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.logging.Logger;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.switchyard.common.io.Files;
import org.switchyard.common.io.pull.StringPuller;
import org.switchyard.test.ArquillianUtil;

@RunWith(value=Arquillian.class)
public class TransformDatamapperQuickstartTest {
    private static final Logger LOGGER = Logger.getLogger(TransformDatamapperQuickstartTest.class);
    private static final String SOURCE_INPUT_FILE = "target/test-classes/org/switchyard/test/quickstarts/transform-datamapper/abc-order.xml";
    private static final String DEST_INPUT_FILE = "target/input/abc-order.xml";
    private static final String ACTUAL_OUTPUT_FILE = "target/output/xyz-order.json";
    private static final String EXPECTED_OUTPUT_FILE = "target/test-classes/org/switchyard/test/quickstarts/transform-datamapper/xyz-order.json";

    @Deployment(testable=false)
    public static JavaArchive createDeployment() {
        return ArquillianUtil.createJarQSDeployment((String)"switchyard-transform-datamapper");
    }

    @Test
    public void testDeployment() throws Exception {
        File output = new File(ACTUAL_OUTPUT_FILE);
        if (output.exists()) {
            output.delete();
        }
        Files.copy((File)new File(SOURCE_INPUT_FILE), (File)new File(DEST_INPUT_FILE));
        for (int i = 0; !output.exists() && i < 10; ++i) {
            LOGGER.info((Object)"Waiting for an output file to be written...");
            Thread.sleep(1000L);
        }
        Assert.assertTrue((String)("The output file '" + output.getPath() + "' was not found"), (boolean)output.exists());
        Assert.assertEquals((Object)this.jsonUnprettyPrint(this.readFile(EXPECTED_OUTPUT_FILE)), (Object)this.jsonUnprettyPrint(this.readFile(ACTUAL_OUTPUT_FILE)));
    }

    private String readFile(String filePath) throws Exception {
        return new StringPuller().pull((InputStream)new FileInputStream(filePath));
    }

    private String jsonUnprettyPrint(String jsonString) throws JsonProcessingException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true);
        JsonNode node = mapper.readTree(jsonString);
        return node.toString();
    }
}

