/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.test.quickstarts;

import javax.xml.namespace.QName;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.dmr.ModelNode;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.switchyard.component.test.mixins.http.HTTPMixIn;
import org.switchyard.test.ArquillianUtil;

@RunWith(value=Arquillian.class)
public class HttpBindingQuickstartTest {
    private static final String BASE_URL = "http://localhost:8080/http-binding";

    @Deployment(testable=false)
    public static JavaArchive createDeployment() {
        return ArquillianUtil.createJarQSDeployment((String)"switchyard-http-binding");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void quoteService() throws Exception {
        HTTPMixIn httpMixIn = new HTTPMixIn();
        httpMixIn.initialize();
        try {
            String response = httpMixIn.sendString("http://localhost:8080/http-binding/quote", "vineyard", "POST");
            Assert.assertEquals((Object)"136.5", (Object)response);
        }
        finally {
            httpMixIn.uninitialize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void gatewayRestart(@ArquillianResource ManagementClient client) throws Exception {
        HTTPMixIn httpMixIn = new HTTPMixIn();
        httpMixIn.initialize();
        try {
            String response = httpMixIn.sendString("http://localhost:8080/http-binding/quote", "vineyard", "POST");
            Assert.assertEquals((Object)"136.5", (Object)response);
            String namespace = "urn:switchyard-quickstart:http-binding:1.0";
            ModelNode operation = new ModelNode();
            operation.get("address").add("subsystem", "switchyard");
            operation.get("name").set("_QuoteService_http_1");
            operation.get("service-name").set(new QName("urn:switchyard-quickstart:http-binding:1.0", "QuoteService").toString());
            operation.get("application-name").set(new QName("urn:switchyard-quickstart:http-binding:1.0", "http-binding").toString());
            operation.get("operation").set("stop-gateway");
            ModelNode result = client.getControllerClient().execute(operation);
            Assert.assertEquals((String)("Failed to stop gateway: " + result.toString()), (Object)"success", (Object)result.get("outcome").asString());
            Assert.assertEquals((long)404L, (long)httpMixIn.sendStringAndGetStatus("http://localhost:8080/http-binding/quote", "vineyard", "POST"));
            operation.get("operation").set("start-gateway");
            result = client.getControllerClient().execute(operation);
            Assert.assertEquals((String)("Failed to restart gateway: " + result.toString()), (Object)"success", (Object)result.get("outcome").asString());
            Assert.assertEquals((Object)"136.5", (Object)httpMixIn.sendString("http://localhost:8080/http-binding/quote", "vineyard", "POST"));
        }
        finally {
            httpMixIn.uninitialize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void headers() throws Exception {
        HTTPMixIn httpMixIn = new HTTPMixIn();
        httpMixIn.initialize();
        try {
            String response = httpMixIn.sendString("http://localhost:8080/http-binding/symbol", "headers", "POST");
            Assert.assertTrue((String)("Unexpected response: [" + response + "]"), (response.toLowerCase().indexOf("content-type=text/xml; charset=utf-8") >= 0 ? 1 : 0) != 0);
            int status = httpMixIn.sendStringAndGetStatus("http://localhost:8080/http-binding/symbol", "rum", "POST");
            Assert.assertEquals((long)404L, (long)status);
        }
        finally {
            httpMixIn.uninitialize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void requestInfo() throws Exception {
        HTTPMixIn httpMixIn = new HTTPMixIn();
        httpMixIn.initialize();
        try {
            String response = httpMixIn.sendString("http://localhost:8080/http-binding/symbol", "requestInfo", "POST");
            Assert.assertTrue((response.indexOf("HttpRequestInfo [authType=null, characterEncoding=UTF-8, contentType=text/xml; charset=UTF-8, contextPath=") == 0 ? 1 : 0) != 0);
        }
        finally {
            httpMixIn.uninitialize();
        }
    }
}

