/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.test.quickstarts;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import javax.xml.namespace.QName;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.dmr.ModelNode;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.switchyard.test.ArquillianUtil;

@RunWith(value=Arquillian.class)
public class CamelJpaBindingQuickstartTest {
    private static final String namespace = "urn:switchyard-quickstart:camel-jpa-binding:0.1.0";
    private static final String application = new QName("urn:switchyard-quickstart:camel-jpa-binding:0.1.0", "camel-jpa-retrieve-binding").toString();
    private static final String quartzService = new QName("urn:switchyard-quickstart:camel-jpa-binding:0.1.0", "PeriodicService").toString();
    private static final String quartzBinding = "_PeriodicService_quartz_1";
    private static final String greetingService = new QName("urn:switchyard-quickstart:camel-jpa-binding:0.1.0", "GreetingService").toString();
    private static final String greetingBinding = "_GreetingService_jpa_1";
    private static final String storeReference = new QName("urn:switchyard-quickstart:camel-jpa-binding:0.1.0", "StoreReference").toString();
    private static final String storeBinding = "_StoreReference_jpa_1";
    @ArquillianResource
    private ManagementClient _client;

    @Deployment(testable=true)
    public static JavaArchive createDeployment() throws IOException {
        return ArquillianUtil.createJarQSDeployment((String)"switchyard-camel-jpa-binding");
    }

    @Test
    @RunAsClient
    @InSequence(value=1)
    public void testStopStoreGateway() throws Exception {
        Thread.sleep(6000L);
        this.executeOperation(storeReference, storeBinding, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @InSequence(value=2)
    public void testStoreGatewayStopped(@ArquillianResource InitialContext context) throws Exception {
        Connection connection = null;
        Statement statement = null;
        try {
            Thread.sleep(6000L);
            DataSource ds = (DataSource)context.lookup("java:jboss/datasources/ExampleDS");
            connection = ds.getConnection();
            this.assertEvents(connection, "StoreReference not disabled.", false);
            statement = connection.createStatement();
            statement.execute("INSERT INTO events (sender,receiver,createdAt) values ('John', 'Rambo', NOW())");
            Assert.assertEquals((long)1L, (long)statement.getUpdateCount());
            statement.close();
            statement = null;
            Thread.sleep(1000L);
            this.assertEvents(connection, "GreetingService not running.", false);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception e) {
                    e.fillInStackTrace();
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception e) {
                    e.fillInStackTrace();
                }
            }
        }
    }

    @Test
    @RunAsClient
    @InSequence(value=3)
    public void testRestartStoreGateway() throws Exception {
        this.executeOperation(greetingService, greetingBinding, false);
        this.executeOperation(storeReference, storeBinding, true);
    }

    @Test
    @InSequence(value=4)
    public void testGreetingGatewayStopped(@ArquillianResource InitialContext context) throws Exception {
        Thread.sleep(6000L);
        this.assertEvents(context, "GreetingService not stopped or StoreReference not restarted.", true);
    }

    @Test
    @RunAsClient
    @InSequence(value=5)
    public void testStopQuartzGateway() throws Exception {
        this.executeOperation(quartzService, quartzBinding, false);
        this.executeOperation(greetingService, greetingBinding, true);
        Thread.sleep(6000L);
        this.executeOperation(greetingService, greetingBinding, false);
    }

    @Test
    @InSequence(value=6)
    public void testQuartzGatewayStopped(@ArquillianResource InitialContext context) throws Exception {
        Thread.sleep(6000L);
        this.assertEvents(context, "Quartz gateway not stopped.", false);
    }

    private void executeOperation(String serviceName, String bindingName, boolean start) throws Exception {
        ModelNode operation = new ModelNode();
        operation.get("address").add("subsystem", "switchyard");
        operation.get("application-name").set(application);
        if (start) {
            operation.get("operation").set("start-gateway");
        } else {
            operation.get("operation").set("stop-gateway");
        }
        operation.get("name").set(bindingName);
        operation.get("service-name").set(serviceName);
        ModelNode result = this._client.getControllerClient().execute(operation);
        Assert.assertEquals((String)("Failed to " + (start ? "start" : "stop") + " gateway: " + result.toString()), (Object)"success", (Object)result.get("outcome").asString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertEvents(InitialContext context, String message, boolean expected) throws Exception {
        Connection connection = null;
        try {
            DataSource ds = (DataSource)context.lookup("java:jboss/datasources/ExampleDS");
            connection = ds.getConnection();
            this.assertEvents(connection, message, expected);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception e) {
                    e.fillInStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertEvents(Connection connection, String message, boolean expected) throws Exception {
        Statement statement = null;
        try {
            statement = connection.createStatement();
            boolean containsEvents = statement.execute("SELECT * FROM events");
            if (containsEvents) {
                ResultSet rs = statement.getResultSet();
                containsEvents = rs.next();
                rs.close();
            }
            Assert.assertEquals((String)message, (Object)expected, (Object)containsEvents);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception e) {
                    e.fillInStackTrace();
                }
            }
        }
    }
}

