/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.test.quickstarts.demo;

import java.io.IOException;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.switchyard.component.test.mixins.hornetq.HornetQMixIn;
import org.switchyard.test.ArquillianUtil;
import org.switchyard.test.quickstarts.util.ResourceDeployer;

@RunWith(value=Arquillian.class)
public class PolicyTransactionDemoQuickstartTest {
    private static final String QUEUE_IN = "policyQSTransacted";
    private static final String QUEUE_IN_NOTX = "policyQSNonTransacted";
    private static final String QUEUE_OUT_A = "queueA";
    private static final String QUEUE_OUT_B = "queueB";
    private static final String QUEUE_OUT_C = "queueC";
    private HornetQMixIn _hqMixIn;

    @Deployment(testable=false)
    public static JavaArchive createDeployment() throws IOException {
        System.out.println(ResourceDeployer.addQueue(QUEUE_IN));
        System.out.println(ResourceDeployer.addQueue(QUEUE_IN_NOTX));
        System.out.println(ResourceDeployer.addQueue(QUEUE_OUT_A));
        System.out.println(ResourceDeployer.addQueue(QUEUE_OUT_B));
        System.out.println(ResourceDeployer.addQueue(QUEUE_OUT_C));
        System.out.println(ResourceDeployer.addPooledConnectionFactory("hornetq-ra-in", true, "java:/JmsXAIn"));
        System.out.println(ResourceDeployer.addPooledConnectionFactory("hornetq-ra-out-a", true, "java:/JmsXAOutA"));
        System.out.println(ResourceDeployer.addPooledConnectionFactory("hornetq-ra-out-b", true, "java:/JmsXAOutB"));
        System.out.println(ResourceDeployer.addPooledConnectionFactory("hornetq-ra-out-c", true, "java:/JmsXAOutC"));
        return ArquillianUtil.createJarDemoDeployment((String)"switchyard-demo-policy-transaction");
    }

    @Before
    public void before() throws Exception {
        this._hqMixIn = new HornetQMixIn(false).setUser("guest").setPassword("Guestp123!");
        this._hqMixIn.initialize();
        this.cleanupQueues(this._hqMixIn);
    }

    @After
    public void after() throws Exception {
        this.cleanupQueues(this._hqMixIn);
        this._hqMixIn.uninitialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupQueues(HornetQMixIn mixin) {
        Session session = mixin.createJMSSession();
        try {
            MessageConsumer consumer = session.createConsumer((Destination)HornetQMixIn.getJMSQueue((String)QUEUE_IN));
            while (consumer.receive(1000L) != null) {
            }
            consumer = session.createConsumer((Destination)HornetQMixIn.getJMSQueue((String)QUEUE_OUT_A));
            while (consumer.receive(1000L) != null) {
            }
            consumer = session.createConsumer((Destination)HornetQMixIn.getJMSQueue((String)QUEUE_OUT_B));
            while (consumer.receive(1000L) != null) {
            }
            consumer = session.createConsumer((Destination)HornetQMixIn.getJMSQueue((String)QUEUE_OUT_C));
            while (consumer.receive(1000L) != null) {
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                session.close();
            }
            catch (Exception exception) {}
        }
    }

    @AfterClass
    public static void afterClass() throws Exception {
        System.out.println(ResourceDeployer.removeQueue(QUEUE_IN));
        System.out.println(ResourceDeployer.removeQueue(QUEUE_IN_NOTX));
        System.out.println(ResourceDeployer.removeQueue(QUEUE_OUT_A));
        System.out.println(ResourceDeployer.removeQueue(QUEUE_OUT_B));
        System.out.println(ResourceDeployer.removeQueue(QUEUE_OUT_C));
        System.out.println(ResourceDeployer.removePooledConnectionFactory("hornetq-ra-in"));
        System.out.println(ResourceDeployer.removePooledConnectionFactory("hornetq-ra-out-a"));
        System.out.println(ResourceDeployer.removePooledConnectionFactory("hornetq-ra-out-b"));
        System.out.println(ResourceDeployer.removePooledConnectionFactory("hornetq-ra-out-c"));
    }

    @Test
    public void testRollbackA() throws Exception {
        String command = "rollback.A";
        Session session = this._hqMixIn.createJMSSession();
        MessageProducer producer = session.createProducer((Destination)HornetQMixIn.getJMSQueue((String)QUEUE_IN));
        ObjectMessage message = this._hqMixIn.createJMSMessage(command);
        producer.send((Message)message);
        session.close();
        session = this._hqMixIn.createJMSSession();
        MessageConsumer consumer = session.createConsumer((Destination)HornetQMixIn.getJMSQueue((String)QUEUE_OUT_A));
        TextMessage msg = (TextMessage)TextMessage.class.cast(consumer.receive(30000L));
        Assert.assertEquals((Object)command, (Object)msg.getText());
        Assert.assertNull((Object)consumer.receive(1000L));
        consumer = session.createConsumer((Destination)HornetQMixIn.getJMSQueue((String)QUEUE_OUT_B));
        msg = (TextMessage)TextMessage.class.cast(consumer.receive(10000L));
        Assert.assertEquals((Object)command, (Object)msg.getText());
        msg = (TextMessage)TextMessage.class.cast(consumer.receive(10000L));
        Assert.assertEquals((Object)command, (Object)msg.getText());
        msg = (TextMessage)TextMessage.class.cast(consumer.receive(10000L));
        Assert.assertEquals((Object)command, (Object)msg.getText());
        msg = (TextMessage)TextMessage.class.cast(consumer.receive(10000L));
        Assert.assertEquals((Object)command, (Object)msg.getText());
        Assert.assertNull((Object)consumer.receive(1000L));
        consumer = session.createConsumer((Destination)HornetQMixIn.getJMSQueue((String)QUEUE_OUT_C));
        msg = (TextMessage)TextMessage.class.cast(consumer.receive(10000L));
        Assert.assertEquals((Object)command, (Object)msg.getText());
        msg = (TextMessage)TextMessage.class.cast(consumer.receive(10000L));
        Assert.assertEquals((Object)command, (Object)msg.getText());
        msg = (TextMessage)TextMessage.class.cast(consumer.receive(10000L));
        Assert.assertEquals((Object)command, (Object)msg.getText());
        msg = (TextMessage)TextMessage.class.cast(consumer.receive(10000L));
        Assert.assertEquals((Object)command, (Object)msg.getText());
        Assert.assertNull((Object)consumer.receive(1000L));
        session.close();
    }

    @Test
    public void testRollbackB() throws Exception {
        String command = "rollback.B";
        Session session = this._hqMixIn.createJMSSession();
        MessageProducer producer = session.createProducer((Destination)HornetQMixIn.getJMSQueue((String)QUEUE_IN));
        ObjectMessage message = this._hqMixIn.createJMSMessage(command);
        producer.send((Message)message);
        session.close();
        session = this._hqMixIn.createJMSSession();
        MessageConsumer consumer = session.createConsumer((Destination)HornetQMixIn.getJMSQueue((String)QUEUE_OUT_A));
        TextMessage msg = (TextMessage)TextMessage.class.cast(consumer.receive(30000L));
        Assert.assertEquals((Object)command, (Object)msg.getText());
        Assert.assertNull((Object)consumer.receive(1000L));
        consumer = session.createConsumer((Destination)HornetQMixIn.getJMSQueue((String)QUEUE_OUT_B));
        msg = (TextMessage)TextMessage.class.cast(consumer.receive(10000L));
        Assert.assertEquals((Object)command, (Object)msg.getText());
        Assert.assertNull((Object)consumer.receive(1000L));
        consumer = session.createConsumer((Destination)HornetQMixIn.getJMSQueue((String)QUEUE_OUT_C));
        msg = (TextMessage)TextMessage.class.cast(consumer.receive(10000L));
        Assert.assertEquals((Object)command, (Object)msg.getText());
        Assert.assertNull((Object)consumer.receive(1000L));
        session.close();
    }

    @Test
    public void testNonTransacted() throws Exception {
        String command = "rollback.A";
        Session session = this._hqMixIn.createJMSSession();
        MessageProducer producer = session.createProducer((Destination)HornetQMixIn.getJMSQueue((String)QUEUE_IN_NOTX));
        ObjectMessage message = this._hqMixIn.createJMSMessage(command);
        producer.send((Message)message);
        session.close();
        session = this._hqMixIn.createJMSSession();
        MessageConsumer consumer = session.createConsumer((Destination)HornetQMixIn.getJMSQueue((String)QUEUE_OUT_A));
        Assert.assertNull((Object)consumer.receive(1000L));
        consumer = session.createConsumer((Destination)HornetQMixIn.getJMSQueue((String)QUEUE_OUT_B));
        Assert.assertNull((Object)consumer.receive(1000L));
        consumer = session.createConsumer((Destination)HornetQMixIn.getJMSQueue((String)QUEUE_OUT_C));
        Assert.assertNull((Object)consumer.receive(1000L));
        session.close();
    }
}

