/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.test.jca;

import java.io.IOException;
import java.net.URL;
import javax.naming.InitialContext;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.MappedRecord;
import javax.resource.cci.Record;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.ResourceAdapterArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.beans10.BeansDescriptor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.switchyard.common.type.Classes;
import org.switchyard.test.jca.JCACCIReference;
import org.switchyard.test.jca.JCACCIReferenceService;
import org.switchyard.test.jca.JCACCIReferenceServiceImpl;
import org.switchyard.test.jca.mockra.InteractionListener;
import org.switchyard.test.jca.mockra.MockConnectionFactory;
import org.switchyard.test.jca.mockra.MockRecordFactory;
import org.switchyard.test.jca.mockra.MockResourceAdapter;
import org.switchyard.test.jca.mockra.MockResourceAdapterUtil;

@RunWith(value=Arquillian.class)
public class JCACCIReferenceBindingTest {
    private static final String TEST_CONFIG = "org/switchyard/test/jca/switchyard-outbound-cci-test.xml";
    private static final String DEPLOYMENT_STRUCTURE = "org/switchyard/test/jca/cci-test-app-deployment-structure.xml";
    private static final String JNDI_PROPERTIES = "org/switchyard/test/jca/outbound-jms-jndi.properties";
    private static final String APP_NAME = "switchyard-JCACCIReferenceBindingTest.jar";
    private MockResourceAdapter _adapter;
    private MockRecordFactory _recordFactory;
    @ArquillianResource
    InitialContext _context;

    @Deployment(order=1, name="myeis-ra.rar")
    public static ResourceAdapterArchive createResourceAdapter() throws IOException {
        return MockResourceAdapterUtil.createMockResourceAdapterArchive();
    }

    @Deployment(order=2)
    public static JavaArchive createDeployment() throws Exception {
        URL testConfigUrl = Classes.getResource((String)TEST_CONFIG);
        URL deploymentStructureUrl = Classes.getResource((String)DEPLOYMENT_STRUCTURE);
        URL jndiProperties = Classes.getResource((String)JNDI_PROPERTIES);
        String beansXml = ((BeansDescriptor)Descriptors.create(BeansDescriptor.class)).exportAsString();
        return (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)APP_NAME)).addClass(JCACCIReference.class)).addClass(JCACCIReferenceService.class)).addClass(JCACCIReferenceServiceImpl.class)).addAsResource((Asset)new UrlAsset(jndiProperties), "jndi.properties")).addAsManifestResource((Asset)new UrlAsset(deploymentStructureUrl), "jboss-deployment-structure.xml")).addAsManifestResource((Asset)new UrlAsset(testConfigUrl), "switchyard.xml")).addAsManifestResource((Asset)new StringAsset(beansXml), "beans.xml");
    }

    @Before
    public void before() {
        try {
            this._recordFactory = new MockRecordFactory();
            MockConnectionFactory factory = (MockConnectionFactory)this._context.lookup("java:jboss/MyEISConnectionFactory");
            factory.setInteractionListener(new InteractionListener(){

                @Override
                public Record onExecute(InteractionSpec spec, Record input) {
                    MappedRecord mapped = (MappedRecord)input;
                    mapped.put((Object)"name", (Object)("Hello, " + mapped.get((Object)"name") + "!"));
                    return mapped;
                }

                @Override
                public boolean onExecute(InteractionSpec spec, Record input, Record output) {
                    return true;
                }
            });
            this._adapter = (MockResourceAdapter)this._context.lookup("MyEISResourceAdapter");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testOutboundCCI() throws Exception {
        this._adapter.fireCreateEndpoint();
        MappedRecord input = this._recordFactory.createMappedRecord("testOutboundCCI input");
        input.put((Object)"name", (Object)"Uragasumi");
        Record result = this._adapter.fireDelivery((Record)input);
        this._adapter.fireRelease();
        Assert.assertTrue((boolean)(result instanceof MappedRecord));
        Assert.assertEquals((Object)"Hello, Uragasumi!", (Object)((MappedRecord)MappedRecord.class.cast(result)).get((Object)"name"));
    }
}

