/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.test.jca;

import java.io.IOException;
import java.net.URL;
import javax.naming.InitialContext;
import javax.resource.cci.MappedRecord;
import javax.resource.cci.Record;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.ResourceAdapterArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.beans10.BeansDescriptor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.switchyard.common.type.Classes;
import org.switchyard.test.jca.JCACCIService;
import org.switchyard.test.jca.JCACCIServiceImpl;
import org.switchyard.test.jca.mockra.MockRecordFactory;
import org.switchyard.test.jca.mockra.MockResourceAdapter;
import org.switchyard.test.jca.mockra.MockResourceAdapterUtil;

@RunWith(value=Arquillian.class)
public class JCACCIServiceBindingTest {
    private static final String TEST_CONFIG = "org/switchyard/test/jca/switchyard-inbound-cci-test.xml";
    private static final String DEPLOYMENT_STRUCTURE = "org/switchyard/test/jca/cci-test-app-deployment-structure.xml";
    private static final String APP_NAME = "switchyard-JCACCIServiceBindingTest.jar";
    private MockResourceAdapter _adapter;
    private MockRecordFactory _recordFactory;
    @ArquillianResource
    private InitialContext _context;

    @Deployment(order=1, name="myeis-ra.rar")
    public static ResourceAdapterArchive createResourceAdapter() throws IOException {
        return MockResourceAdapterUtil.createMockResourceAdapterArchive();
    }

    @Deployment(order=2)
    public static JavaArchive createDeployment() throws Exception {
        URL testConfigUrl = Classes.getResource((String)TEST_CONFIG);
        URL deploymentStructureUrl = Classes.getResource((String)DEPLOYMENT_STRUCTURE);
        String beansXml = ((BeansDescriptor)Descriptors.create(BeansDescriptor.class)).exportAsString();
        return (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)APP_NAME)).addClass(JCACCIService.class)).addClass(JCACCIServiceImpl.class)).addAsManifestResource((Asset)new UrlAsset(deploymentStructureUrl), "jboss-deployment-structure.xml")).addAsManifestResource((Asset)new UrlAsset(testConfigUrl), "switchyard.xml")).addAsManifestResource((Asset)new StringAsset(beansXml), "beans.xml");
    }

    @Before
    public void before() {
        try {
            this._recordFactory = new MockRecordFactory();
            this._adapter = (MockResourceAdapter)this._context.lookup("MyEISResourceAdapter");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testInflowCCI() throws Exception {
        this._adapter.fireCreateEndpoint();
        MappedRecord input = this._recordFactory.createMappedRecord("testInflowCCI input");
        input.put((Object)"input", (Object)"World");
        Record result = this._adapter.fireDelivery((Record)input);
        this._adapter.fireRelease();
        Assert.assertTrue((boolean)(result instanceof MappedRecord));
        Assert.assertEquals((Object)"Hello World !", (Object)((MappedRecord)result).get((Object)"input"));
    }

    @Test
    public void testInflowCCIWithBeforeAfterDelivery() throws Exception {
        this._adapter.fireCreateEndpoint();
        this._adapter.fireBeforeDelivery();
        MappedRecord input1 = this._recordFactory.createMappedRecord("testInflowCCIWithBeforeAfterDelivery input1");
        input1.put((Object)"input", (Object)"World2");
        Record result1 = this._adapter.fireDelivery((Record)input1);
        this._adapter.fireAfterDelivery();
        Assert.assertTrue((boolean)(result1 instanceof MappedRecord));
        Assert.assertEquals((Object)"Hello World2 !", (Object)((MappedRecord)result1).get((Object)"input"));
    }

    @Test
    public void testInflowCCIReuseReleasedEndpoint() throws Exception {
        this._adapter.fireCreateEndpoint();
        MappedRecord input1 = this._recordFactory.createMappedRecord("testInflowCCIReuseReleasedEndpoint input1");
        input1.put((Object)"input", (Object)"World3");
        Record result1 = this._adapter.fireDelivery((Record)input1);
        Assert.assertTrue((boolean)(result1 instanceof MappedRecord));
        Assert.assertEquals((Object)"Hello World3 !", (Object)((MappedRecord)result1).get((Object)"input"));
        this._adapter.fireRelease();
        MappedRecord input2 = this._recordFactory.createMappedRecord("testInflowCCIReuseReleasedEndpoint input2");
        input2.put((Object)"input", (Object)"World4");
        Record result2 = this._adapter.fireDelivery((Record)input2);
        Assert.assertTrue((boolean)(result2 instanceof MappedRecord));
        Assert.assertEquals((Object)"Hello World4 !", (Object)((MappedRecord)result2).get((Object)"input"));
    }

    @Test(expected=RuntimeException.class)
    public void testInflowCCIErrorMultipleDelivery() throws Exception {
        this._adapter.fireCreateEndpoint();
        this._adapter.fireBeforeDelivery();
        MappedRecord input1 = this._recordFactory.createMappedRecord("testInflowCCIErrorMultipleDelivery input1");
        input1.put((Object)"input", (Object)"World5");
        MappedRecord input2 = this._recordFactory.createMappedRecord("testInflowCCIErrorMultipleDelivery input2");
        input2.put((Object)"input", (Object)"World6");
        Record result1 = this._adapter.fireDelivery((Record)input1);
        Record result2 = this._adapter.fireDelivery((Record)input2);
    }

    @Test(expected=RuntimeException.class)
    public void testInflowCCIErrorAfterDeliveryWithoutBefore() throws Exception {
        this._adapter.fireCreateEndpoint();
        MappedRecord input1 = this._recordFactory.createMappedRecord("testInflowCCIErrorAfterDeliveryWithoutBefore input1");
        input1.put((Object)"input", (Object)"World7");
        Record result1 = this._adapter.fireDelivery((Record)input1);
        this._adapter.fireAfterDelivery();
    }

    @Test(expected=RuntimeException.class)
    public void testInflowCCIErrorBeforeDeliveryWithoutPreviousAfter() throws Exception {
        this._adapter.fireCreateEndpoint();
        this._adapter.fireBeforeDelivery();
        MappedRecord input1 = this._recordFactory.createMappedRecord("testInflowCCIErrorBeforeDeliveryWithoutPreviousAfter input1");
        input1.put((Object)"input", (Object)"World8");
        Record result1 = this._adapter.fireDelivery((Record)input1);
        this._adapter.fireBeforeDelivery();
    }
}

