/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.test.quickstarts;

import org.apache.activemq.broker.BrokerService;
import org.fusesource.mqtt.client.BlockingConnection;
import org.fusesource.mqtt.client.MQTT;
import org.fusesource.mqtt.client.QoS;
import org.fusesource.mqtt.client.Topic;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.AfterClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.switchyard.test.ArquillianUtil;

@RunWith(value=Arquillian.class)
public class CamelMQTTBindingQuickstartTest {
    private static final String TOPIC_INPUT = "camel/mqtt/test/input";
    private static final String TOPIC_OUTPUT = "camel/mqtt/test/output";
    private static final String MESSAGE_INPUT = "SpongeBob";
    private static final String MESSAGE_OUTPUT = "Hello there SpongeBob :-) ";
    private static final String USER_NAME = "karaf";
    private static final String PASSWORD = "karaf";
    private static BrokerService _broker;

    @Deployment(testable=false)
    public static JavaArchive createDeployment() throws Exception {
        _broker = new BrokerService();
        _broker.setBrokerName("default");
        _broker.setUseJmx(false);
        _broker.setPersistent(false);
        _broker.addConnector("mqtt://localhost:1883");
        _broker.setUseShutdownHook(false);
        _broker.start();
        return ArquillianUtil.createJarQSDeployment((String)"switchyard-camel-mqtt-binding");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeployment() throws Exception {
        BlockingConnection publishConnection = null;
        BlockingConnection subscribeConnection = null;
        try {
            Topic outputTopic = new Topic(TOPIC_OUTPUT, QoS.AT_LEAST_ONCE);
            MQTT mqtt = new MQTT();
            mqtt.setUserName("karaf");
            mqtt.setPassword("karaf");
            subscribeConnection = mqtt.blockingConnection();
            subscribeConnection.connect();
            subscribeConnection.subscribe(new Topic[]{outputTopic});
            publishConnection = mqtt.blockingConnection();
            publishConnection.connect();
            publishConnection.publish(TOPIC_INPUT, MESSAGE_INPUT.getBytes(), QoS.AT_LEAST_ONCE, false);
        }
        finally {
            if (publishConnection != null && publishConnection.isConnected()) {
                publishConnection.disconnect();
            }
            if (subscribeConnection != null && subscribeConnection.isConnected()) {
                subscribeConnection.disconnect();
            }
        }
    }

    @AfterClass
    public static void cleanup() throws Exception {
        if (_broker != null) {
            _broker.stop();
        }
    }
}

