/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.test.quickstarts;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import org.custommonkey.xmlunit.XMLUnit;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.switchyard.component.test.mixins.http.HTTPMixIn;
import org.switchyard.test.ArquillianUtil;

@RunWith(value=Arquillian.class)
public class SoapAddressingQuickstartTest {
    private static final String SWITCHYARD_WEB_SERVICE = "http://localhost:8080/soap-addressing/order/OrderService";
    private HTTPMixIn _httpMixIn = new HTTPMixIn();
    private static String REQUEST = "<S:Envelope xmlns:S=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:ns2=\"urn:switchyard-quickstart:soap-addressing:1.0\">    <S:Body>        <ns2:order>            <item>Boeing</item>            <quantity>10</quantity>        </ns2:order>    </S:Body></S:Envelope>";
    private static String REQUEST2 = "<S:Envelope xmlns:S=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:ns2=\"urn:switchyard-quickstart:soap-addressing:1.0\">    <S:Header xmlns:wsa=\"http://www.w3.org/2005/08/addressing\">        <wsa:MessageID>uuid:3d3fcbbb-fd43-4118-b40e-62577894f39a</wsa:MessageID>        <wsa:Action>urn:switchyard-quickstart:soap-addressing:1.0:OrderService:orderRequest</wsa:Action>    </S:Header>    <S:Body>        <ns2:order>            <item>Boeing</item>            <quantity>10</quantity>        </ns2:order>    </S:Body></S:Envelope>";

    @Deployment(testable=false)
    public static JavaArchive createDeployment() {
        return ArquillianUtil.createJarQSDeployment((String)"switchyard-soap-addressing");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void addressingError() throws Exception {
        this._httpMixIn.initialize();
        try {
            XMLUnit.setIgnoreWhitespace((boolean)true);
            String response = this._httpMixIn.postString(SWITCHYARD_WEB_SERVICE, REQUEST);
            Assert.assertTrue((boolean)response.contains("MessageAddressingHeaderRequired"));
            Assert.assertTrue((boolean)response.contains("A required header representing a Message Addressing Property is not present"));
        }
        finally {
            this._httpMixIn.uninitialize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void addressingReplyTo() throws Exception {
        this._httpMixIn.initialize();
        try {
            File testFile = new File("/tmp/test.txt");
            if (testFile.exists()) {
                testFile.delete();
            }
            String response = this._httpMixIn.postString(SWITCHYARD_WEB_SERVICE, REQUEST2);
            Assert.assertTrue((boolean)response.contains("urn:switchyard-quickstart:soap-addressing:1.0:OrderService:orderResponse"));
            Assert.assertTrue((boolean)response.contains("uuid:3d3fcbbb-fd43-4118-b40e-62577894f39a"));
            Assert.assertTrue((boolean)response.contains("Thank you for your order. You should hear back from our WarehouseService shortly!"));
            int timeout = 0;
            while (!testFile.exists()) {
                Thread.sleep(100L);
                if ((timeout += 100) != 5000) continue;
            }
            BufferedReader stream = new BufferedReader(new FileReader(testFile));
            String text = stream.readLine();
            stream.close();
            Assert.assertEquals((Object)"Order Boeing with quantity 10 accepted.", (Object)text);
        }
        finally {
            this._httpMixIn.uninitialize();
        }
    }
}

