/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.test.quickstarts.demo;

import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.custommonkey.xmlunit.XMLAssert;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.as.arquillian.api.ServerSetup;
import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.switchyard.common.codec.Base64;
import org.switchyard.common.io.pull.StringPuller;
import org.switchyard.component.test.mixins.http.HTTPMixIn;
import org.switchyard.test.ArquillianUtil;
import org.switchyard.test.quickstarts.util.ResourceDeployer;

@RunWith(value=Arquillian.class)
@ServerSetup(value={SSLSocketBindingSetupTask.class})
public class PolicySecurityBasicDemoQuickstartTest {
    private static String SRC_DIR = System.getProperty("jboss.home") + "/quickstarts/switchyard/demos/policy-security-basic";

    @Deployment(testable=false)
    public static JavaArchive createDeployment() {
        return ArquillianUtil.createJarDemoDeployment((String)"switchyard-demo-policy-security-basic");
    }

    @Test
    public void testUnsecure() throws Exception {
        String response = this.invokeWorkService("http", 8080, "policy-security-basic", null, null);
        Assert.assertTrue((boolean)response.toLowerCase().contains("fault"));
    }

    @Test
    public void testConfidentialSecure() throws Exception {
        KeyStore keystore = KeyStore.getInstance("JKS");
        keystore.load(new FileInputStream(new File(SRC_DIR, "connector.jks")), "changeit".toCharArray());
        TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
        tmf.init(keystore);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keystore, "changeit".toCharArray());
        SSLContext sslcontext = SSLContext.getInstance("TLS");
        sslcontext.init(keyManagerFactory.getKeyManagers(), tmf.getTrustManagers(), null);
        String response = this.invokeWorkService("https", 8443, "policy-security-basic", new String[]{"kermit", "the-frog-1"}, sslcontext);
        XMLAssert.assertXpathEvaluatesTo((String)"true", (String)"//received", (String)response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String invokeWorkService(String scheme, int port, String context, String[] userPass, SSLContext sslContext) throws Exception {
        String soapRequest = ((String)new StringPuller().pull(new File(SRC_DIR, "src/test/resources/xml/soap-request.xml"))).replaceAll("WORK_CMD", "CMD-" + System.currentTimeMillis());
        HTTPMixIn http = new HTTPMixIn(sslContext);
        if (userPass != null && userPass.length == 2) {
            http.setRequestHeader("Authorization", "Basic " + Base64.encodeFromString((String)(userPass[0] + ":" + userPass[1])));
        }
        http.initialize();
        try {
            String endpoint = String.format("%s://localhost:%s/%s/WorkService", scheme, port, context);
            String string = http.postString(endpoint, soapRequest);
            return string;
        }
        finally {
            http.uninitialize();
        }
    }

    public static class SSLSocketBindingSetupTask
    implements ServerSetupTask {
        public void setup(ManagementClient client, String unused) throws Exception {
            ResourceDeployer.setupSSL(client, new File(SRC_DIR, "connector.jks").getAbsolutePath(), "changeit");
            Thread.sleep(1000L);
        }

        public void tearDown(ManagementClient client, String unused) throws Exception {
            ResourceDeployer.tearDownSSL(client);
        }
    }
}

