/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.test.quickstarts.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;

public class ResourceDeployer {
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 9999;
    public static final String USER = "guest";
    public static final String PASSWD = "Guestp123!";

    private ResourceDeployer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModelNode addQueue(String host, int port, String queueName, String jndiName) throws IOException {
        ModelControllerClient client = ResourceDeployer.createClient(host, port);
        try {
            ModelNode op = new ModelNode();
            op.get("operation").set("add");
            op.get("address").add("subsystem", "messaging");
            op.get("address").add("hornetq-server", "default");
            op.get("address").add("jms-queue", queueName);
            op.get("entries").add(jndiName).add("java:jboss/exported/jms/" + jndiName);
            op.get("durable").set(false);
            ModelNode modelNode = client.execute(op);
            return modelNode;
        }
        finally {
            client.close();
        }
    }

    public static ModelNode addQueue(String host, int port, String queueName) throws IOException {
        return ResourceDeployer.addQueue(host, port, queueName, queueName);
    }

    public static ModelNode addQueue(String queueName) throws IOException {
        return ResourceDeployer.addQueue(DEFAULT_HOST, 9999, queueName, queueName);
    }

    public static ModelNode addQueue(String queueName, String jndiName) throws IOException {
        return ResourceDeployer.addQueue(DEFAULT_HOST, 9999, queueName, jndiName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModelNode removeQueue(String host, int port, String queueName) throws IOException {
        ModelControllerClient client = ResourceDeployer.createClient(host, port);
        try {
            ModelNode op = new ModelNode();
            op.get("operation").set("remove");
            op.get("address").add("subsystem", "messaging");
            op.get("address").add("hornetq-server", "default");
            op.get("address").add("jms-queue", queueName);
            ModelNode modelNode = client.execute(op);
            return modelNode;
        }
        finally {
            client.close();
        }
    }

    public static ModelNode removeQueue(String queueName) throws IOException {
        return ResourceDeployer.addQueue(DEFAULT_HOST, 9999, queueName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModelNode addPooledConnectionFactory(String host, int port, String cfName, boolean xa, String jndiName) throws IOException {
        ModelControllerClient client = ResourceDeployer.createClient(host, port);
        try {
            ModelNode op = new ModelNode();
            op.get("operation").set("add");
            op.get("address").add("subsystem", "messaging");
            op.get("address").add("hornetq-server", "default");
            op.get("address").add("pooled-connection-factory", cfName);
            op.get("transaction").set(xa ? "xa" : "local");
            op.get("connector").set("in-vm", "");
            op.get("entries").add(jndiName);
            ModelNode modelNode = client.execute(op);
            return modelNode;
        }
        finally {
            client.close();
        }
    }

    public static ModelNode addPooledConnectionFactory(String cfName, boolean xa, String jndiName) throws IOException {
        return ResourceDeployer.addPooledConnectionFactory(DEFAULT_HOST, 9999, cfName, xa, jndiName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModelNode removePooledConnectionFactory(String host, int port, String cfName) throws IOException {
        ModelControllerClient client = ResourceDeployer.createClient(host, port);
        try {
            ModelNode op = new ModelNode();
            op.get("operation").set("remove");
            op.get("address").add("subsystem", "messaging");
            op.get("address").add("hornetq-server", "default");
            op.get("address").add("pooled-connection-factory", cfName);
            ModelNode modelNode = client.execute(op);
            return modelNode;
        }
        finally {
            client.close();
        }
    }

    public static ModelNode removePooledConnectionFactory(String cfName) throws IOException {
        return ResourceDeployer.removePooledConnectionFactory(DEFAULT_HOST, 9999, cfName);
    }

    public static void setupSSL(ManagementClient client, String keystorePath, String keystorePassword) throws Exception {
        ModelNode op = new ModelNode();
        op.get("operation").set("add");
        op.get("address").add("subsystem", "web");
        op.get("address").add("connector", "https");
        op.get("socket-binding").set("https");
        op.get("scheme").set("https");
        op.get("protocol").set("HTTP/1.1");
        op.get("secure").set("true");
        op.get("enabled").set("true");
        op.get("enable-lookups").set("false");
        op.get(new String[]{"operation-headers", "allow-resource-service-restart"}).set("true");
        client.getControllerClient().execute(op);
        op = new ModelNode();
        op.get("operation").set("add");
        op.get("address").add("subsystem", "web");
        op.get("address").add("connector", "https");
        op.get("address").add("ssl", "configuration");
        op.get("name").set("https");
        op.get("password").set(keystorePassword);
        op.get("certificate-key-file").set(keystorePath);
        op.get(new String[]{"operation-headers", "allow-resource-service-restart"}).set("true");
        client.getControllerClient().execute(op);
        op = new ModelNode();
        op.get("operation").set("add");
        op.get("address").add("core-service", "management");
        op.get("address").add("security-realm", "SslRealm");
        client.getControllerClient().execute(op);
        op = new ModelNode();
        op.get("operation").set("add");
        op.get("address").add("core-service", "management");
        op.get("address").add("security-realm", "SslRealm");
        op.get("address").add("server-identity", "ssl");
        op.get("keystore-password").set(keystorePassword);
        op.get("keystore-path").set(keystorePath);
        op.get(new String[]{"operation-headers", "allow-resource-service-restart"}).set("true");
        client.getControllerClient().execute(op);
        op = new ModelNode();
        op.get("operation").set("add");
        op.get("address").add("subsystem", "undertow");
        op.get("address").add("server", "default-server");
        op.get("address").add("https-listener", "default-https");
        op.get("socket-binding").set("https");
        op.get("security-realm").set("SslRealm");
        op.get(new String[]{"operation-headers", "allow-resource-service-restart"}).set("true");
        client.getControllerClient().execute(op);
    }

    public static void tearDownSSL(ManagementClient client) throws Exception {
        ModelNode op = new ModelNode();
        op.get("operation").set("remove");
        op.get("address").add("subsystem", "web");
        op.get("address").add("connector", "https");
        client.getControllerClient().execute(op);
        op = new ModelNode();
        op.get("operation").set("remove");
        op.get("address").add("subsystem", "undertow");
        op.get("address").add("server", "default-server");
        op.get("address").add("https-listener", "https");
        client.getControllerClient().execute(op);
        op = new ModelNode();
        op.get("operation").set("remove");
        op.get("address").add("core-service", "management");
        op.get("address").add("security-realm", "SslRealm");
        client.getControllerClient().execute(op);
    }

    private static ModelControllerClient createClient(String host, int port) throws UnknownHostException {
        return ModelControllerClient.Factory.create((InetAddress)InetAddress.getByName(host), (int)port);
    }
}

