/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.config.model.composite.v1;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.switchyard.config.model.Model;

public final class PolicyConfig {
    public static final String REQUIRES = "requires";

    private PolicyConfig() {
    }

    public static Set<String> getRequires(Model model) {
        HashSet<String> requiredSet = new HashSet<String>();
        String requires = model.getModelConfiguration().getAttribute(REQUIRES);
        if (requires != null) {
            for (String policy : requires.split(" ")) {
                requiredSet.add(policy);
            }
        }
        return requiredSet;
    }

    public static void setRequires(Model model, Set<String> requiredSet) {
        if (requiredSet == null || requiredSet.isEmpty()) {
            return;
        }
        Iterator<String> it = requiredSet.iterator();
        String requires = it.next();
        while (it.hasNext()) {
            requires = requires + " " + it.next();
        }
        model.getModelConfiguration().setAttribute(REQUIRES, requires);
    }
}

