/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.config.model.domain.v1;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.switchyard.config.Configuration;
import org.switchyard.config.model.BaseModel;
import org.switchyard.config.model.Descriptor;
import org.switchyard.config.model.domain.PropertiesModel;
import org.switchyard.config.model.domain.PropertyModel;

public class V1PropertiesModel
extends BaseModel
implements PropertiesModel {
    private List<PropertyModel> _properties = new ArrayList<PropertyModel>();

    public V1PropertiesModel() {
        super(new QName("urn:switchyard-config:switchyard:1.0", "properties"));
        this.setModelChildrenOrder("property");
    }

    public V1PropertiesModel(Configuration config, Descriptor desc) {
        super(config, desc);
        for (Configuration property_config : config.getChildrenStartsWith("property")) {
            PropertyModel property = (PropertyModel)this.readModel(property_config);
            if (property == null) continue;
            this._properties.add(property);
        }
        this.setModelChildrenOrder("property");
    }

    @Override
    public synchronized List<PropertyModel> getProperties() {
        return Collections.unmodifiableList(this._properties);
    }

    @Override
    public synchronized PropertiesModel addProperty(PropertyModel property) {
        this.addChildModel(property);
        this._properties.add(property);
        return this;
    }

    @Override
    public PropertyModel getProperty(String name) {
        PropertyModel property = null;
        for (PropertyModel p : this._properties) {
            if (!p.getName().equals(name)) continue;
            property = p;
            break;
        }
        return property;
    }

    @Override
    public PropertyModel removeProperty(String propertyName) {
        PropertyModel removed = null;
        for (PropertyModel property : this._properties) {
            if (!property.getName().equals(propertyName)) continue;
            removed = property;
            this._properties.remove(property);
        }
        return removed;
    }

    @Override
    public Properties toProperties() {
        Properties properties = new Properties();
        for (PropertyModel pm : this.getProperties()) {
            String name = pm.getName();
            String value = pm.getValue();
            if (name == null || value == null) continue;
            properties.setProperty(name, value);
        }
        return properties;
    }

    @Override
    public Map<String, String> toMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (PropertyModel pm : this.getProperties()) {
            String name = pm.getName();
            String value = pm.getValue();
            if (name == null || value == null) continue;
            map.put(name, value);
        }
        return map;
    }
}

