/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.as7.extension.admin;

import javax.xml.namespace.QName;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.switchyard.admin.Application;
import org.switchyard.admin.Service;
import org.switchyard.admin.SwitchYard;
import org.switchyard.as7.extension.admin.ModelNodeCreationUtil;
import org.switchyard.as7.extension.services.SwitchYardAdminService;

public final class SwitchYardSubsystemListServices
implements OperationStepHandler {
    public static final SwitchYardSubsystemListServices INSTANCE = new SwitchYardSubsystemListServices();

    private SwitchYardSubsystemListServices() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                ModelNode services = context.getResult();
                ServiceController controller = context.getServiceRegistry(false).getRequiredService(SwitchYardAdminService.SERVICE_NAME);
                SwitchYard switchYard = (SwitchYard)SwitchYard.class.cast(controller.getService().getValue());
                if (operation.hasDefined("application-name")) {
                    QName applicationName = QName.valueOf(operation.get("application-name").asString());
                    Application application = switchYard.getApplication(applicationName);
                    if (application != null) {
                        for (Service service : application.getServices()) {
                            services.add(ModelNodeCreationUtil.createSimpleServiceNode(service));
                        }
                    }
                } else {
                    for (Service service : switchYard.getServices()) {
                        services.add(ModelNodeCreationUtil.createSimpleServiceNode(service));
                    }
                }
                context.stepCompleted();
            }
        }, OperationContext.Stage.RUNTIME);
        context.stepCompleted();
    }
}

