/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.as7.extension;

import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.infinispan.Cache;
import org.jboss.as.clustering.infinispan.subsystem.CacheService;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.switchyard.as7.extension.deployment.SwitchYardConfigDeploymentProcessor;
import org.switchyard.as7.extension.deployment.SwitchYardConfigProcessor;
import org.switchyard.as7.extension.deployment.SwitchYardDependencyProcessor;
import org.switchyard.as7.extension.deployment.SwitchYardDeploymentProcessor;
import org.switchyard.as7.extension.services.SwitchYardAdminService;
import org.switchyard.as7.extension.services.SwitchYardInjectorService;
import org.switchyard.as7.extension.services.SwitchYardServiceDomainManagerService;
import org.switchyard.as7.extension.services.SwitchYardSystemSecurityService;
import org.switchyard.as7.extension.util.ServerUtil;
import org.switchyard.deploy.ServiceDomainManager;
import org.switchyard.security.system.SystemSecurity;

public final class SwitchYardSubsystemAdd
extends AbstractBoottimeAddStepHandler {
    private static final Logger LOG = Logger.getLogger((String)"org.switchyard");
    static final SwitchYardSubsystemAdd INSTANCE = new SwitchYardSubsystemAdd();

    private SwitchYardSubsystemAdd() {
    }

    protected void populateModel(ModelNode operation, Resource resource) throws OperationFailedException {
        ModelNode submodel = resource.getModel();
        this.populateModel(operation, submodel);
    }

    protected void populateModel(ModelNode operation, ModelNode submodel) throws OperationFailedException {
        if (operation.hasDefined("socket-binding")) {
            submodel.get("socket-binding").set(operation.require("socket-binding"));
        }
        if (operation.hasDefined("properties")) {
            submodel.get("properties").set(operation.require("properties"));
        }
        submodel.get("security-config").setEmptyObject();
        submodel.get("module").setEmptyObject();
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        LOG.trace((Object)("Performing boot time operation " + operation));
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            protected void execute(DeploymentProcessorTarget processorTarget) {
                int priority = 16384;
                processorTarget.addDeploymentProcessor("switchyard", Phase.PARSE, priority++, (DeploymentUnitProcessor)new SwitchYardConfigDeploymentProcessor());
                processorTarget.addDeploymentProcessor("switchyard", Phase.DEPENDENCIES, priority++, (DeploymentUnitProcessor)new SwitchYardDependencyProcessor());
                processorTarget.addDeploymentProcessor("switchyard", Phase.POST_MODULE, priority++, (DeploymentUnitProcessor)new SwitchYardConfigProcessor());
                processorTarget.addDeploymentProcessor("switchyard", Phase.INSTALL, priority++, (DeploymentUnitProcessor)new SwitchYardDeploymentProcessor());
            }
        }, OperationContext.Stage.RUNTIME);
        LOG.info((Object)"Activating SwitchYard Subsystem");
        ServerUtil.setRegistry(context.getServiceRegistry(false));
        SwitchYardInjectorService injectorService = new SwitchYardInjectorService();
        ServiceBuilder injectorServiceBuilder = context.getServiceTarget().addService(SwitchYardInjectorService.SERVICE_NAME, (Service)injectorService);
        if (operation.has("socket-binding")) {
            StringTokenizer sockets = new StringTokenizer(operation.get("socket-binding").asString(), ",");
            while (sockets.hasMoreTokens()) {
                String socketName = sockets.nextToken();
                injectorServiceBuilder.addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{socketName}), SocketBinding.class, injectorService.getSocketBinding(socketName));
            }
        }
        injectorServiceBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        newControllers.add(injectorServiceBuilder.install());
        SwitchYardSystemSecurityService systemSecurityService = new SwitchYardSystemSecurityService();
        newControllers.add(context.getServiceTarget().addService(SwitchYardSystemSecurityService.SERVICE_NAME, (Service)systemSecurityService).install());
        SwitchYardServiceDomainManagerService serviceDomainManagerService = new SwitchYardServiceDomainManagerService();
        newControllers.add(context.getServiceTarget().addService(SwitchYardServiceDomainManagerService.SERVICE_NAME, (Service)serviceDomainManagerService).addDependency(SwitchYardSystemSecurityService.SERVICE_NAME, SystemSecurity.class, serviceDomainManagerService.getSystemSecurity()).addDependency(ServiceBuilder.DependencyType.OPTIONAL, CacheService.getServiceName((String)"cluster", null), Cache.class, serviceDomainManagerService.getCache()).install());
        SwitchYardAdminService adminService = new SwitchYardAdminService();
        ServiceBuilder adminServiceBuilder = context.getServiceTarget().addService(SwitchYardAdminService.SERVICE_NAME, (Service)adminService);
        adminServiceBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        newControllers.add(adminServiceBuilder.addDependency(SwitchYardInjectorService.SERVICE_NAME, Map.class, adminService.getSocketBindings()).addDependency(SwitchYardServiceDomainManagerService.SERVICE_NAME, ServiceDomainManager.class, adminService.getServiceDomainManager()).install());
    }
}

