/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.as7.extension.camel;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Set;
import org.apache.camel.impl.DefaultPackageScanClassResolver;
import org.apache.camel.spi.PackageScanFilter;
import org.jboss.logging.Logger;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.switchyard.as7.extension.ExtensionLogger;

public class JBoss7PackageScanClassResolver
extends DefaultPackageScanClassResolver {
    private static final Logger LOG = Logger.getLogger(JBoss7PackageScanClassResolver.class);

    protected void find(PackageScanFilter test, String packageName, ClassLoader loader, Set<Class<?>> classes) {
        Enumeration urls;
        if (LOG.isTraceEnabled()) {
            LOG.tracef("Searching for: %s in package: %s using classloader: %s", new Object[]{test, packageName, loader.getClass().getName()});
        }
        try {
            urls = this.getResources(loader, packageName);
            if (!urls.hasMoreElements()) {
                LOG.trace((Object)"No URLs returned by classloader");
            }
        }
        catch (IOException ioe) {
            ExtensionLogger.ROOT_LOGGER.cannotReadPackage(packageName, ioe);
            return;
        }
        while (urls.hasMoreElements()) {
            URL url = (URL)urls.nextElement();
            LOG.tracef("URL from classloader: %s", (Object)url);
            if (!url.toString().startsWith("vfs:")) continue;
            try {
                VirtualFile vfsDir = VFS.getChild((URL)url);
                this.handleDirectory(vfsDir, null, classes, test);
            }
            catch (URISyntaxException uriEx) {
                ExtensionLogger.ROOT_LOGGER.failedToParseURL(url.toString(), uriEx);
            }
        }
    }

    private void handleDirectory(VirtualFile file, String path, Set<Class<?>> classes, PackageScanFilter test) {
        for (VirtualFile child : file.getChildren()) {
            String newPath;
            String string = newPath = path == null ? child.getName() : path + '/' + child.getName();
            if (child.isDirectory()) {
                this.handleDirectory(child, newPath, classes, test);
                continue;
            }
            this.handleFile(child, classes, test);
        }
    }

    private void handleFile(VirtualFile file, Set<Class<?>> classes, PackageScanFilter test) {
        if (file.getName().endsWith(".class")) {
            String fqn = file.getPathName();
            String qn = fqn.indexOf("jar/") != -1 ? fqn.substring(fqn.indexOf("jar/") + 4) : (fqn.indexOf("war/WEB-INF/classes/") != -1 ? fqn.substring(fqn.indexOf("war/WEB-INF/classes/") + 20) : fqn.substring(fqn.indexOf("/") + 1));
            this.addIfMatching(test, qn, classes);
        }
    }
}

