/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.as7.extension.admin;

import javax.xml.namespace.QName;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.switchyard.admin.Application;
import org.switchyard.admin.Service;
import org.switchyard.admin.SwitchYard;
import org.switchyard.admin.Throttling;
import org.switchyard.as7.extension.services.SwitchYardAdminService;

public final class SwitchYardSubsystemUpdateThrottling
implements OperationStepHandler {
    public static final SwitchYardSubsystemUpdateThrottling INSTANCE = new SwitchYardSubsystemUpdateThrottling();

    private SwitchYardSubsystemUpdateThrottling() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                ServiceController controller = context.getServiceRegistry(false).getRequiredService(SwitchYardAdminService.SERVICE_NAME);
                SwitchYard switchYard = (SwitchYard)SwitchYard.class.cast(controller.getService().getValue());
                Application application = switchYard.getApplication(QName.valueOf(operation.get("application-name").asString()));
                QName serviceQName = QName.valueOf(operation.get("service-name").asString());
                Service service = application.getService(serviceQName);
                try {
                    Throttling throttling = service.getThrottling();
                    ModelNode throttlingNode = operation.get("throttling");
                    if (throttlingNode != null) {
                        ModelNode enabled = throttlingNode.get("enabled");
                        ModelNode maxRequests = throttlingNode.get("maxRequests");
                        throttling.update(enabled == null || !enabled.isDefined() ? null : Boolean.valueOf(enabled.asBoolean()), maxRequests == null || !maxRequests.isDefined() ? null : Integer.valueOf(maxRequests.asInt()));
                    }
                    context.stepCompleted();
                }
                catch (Throwable e) {
                    throw new OperationFailedException(new ModelNode().set("Error updating throttling: " + e.getMessage()));
                }
            }
        }, OperationContext.Stage.RUNTIME);
        context.stepCompleted();
    }
}

