/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bpm.task.work;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.switchyard.Context;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.ExchangePattern;
import org.switchyard.Message;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.ServiceReference;
import org.switchyard.SynchronousInOutHandler;
import org.switchyard.common.lang.Strings;
import org.switchyard.common.xml.XMLHelper;
import org.switchyard.component.bpm.task.work.BaseTaskHandler;
import org.switchyard.component.bpm.task.work.Task;
import org.switchyard.component.bpm.task.work.TaskManager;

public class SwitchYardServiceTaskHandler
extends BaseTaskHandler {
    private static final Logger LOGGER = Logger.getLogger(SwitchYardServiceTaskHandler.class);
    public static final String SWITCHYARD_SERVICE = "SwitchYard Service";
    public static final String SERVICE_NAME = "ServiceName";
    public static final String SERVICE_OPERATION_NAME = "ServiceOperationName";
    public static final String FAULT_RESULT_NAME = "FaultResultName";
    public static final String FAULT_EVENT_TYPE = "FaultEventType";
    public static final String COMPLETE_AFTER_FAULT = "CompleteAfterFault";

    public SwitchYardServiceTaskHandler() {
        super(SWITCHYARD_SERVICE);
    }

    public SwitchYardServiceTaskHandler(String name) {
        super(name);
    }

    @Override
    public void executeTask(Task task, TaskManager manager) {
        Map<String, Object> parameters = task.getParameters();
        Map<String, Object> results = task.getResults();
        if (results == null) {
            results = new HashMap<String, Object>();
        }
        Object fault = null;
        try {
            QName serviceName = this.getServiceName(parameters);
            if (serviceName == null) {
                throw new IllegalStateException("ServiceName == null");
            }
            ServiceReference serviceRef = this.getServiceDomain().getServiceReference(serviceName);
            if (serviceRef == null) {
                throw new IllegalStateException("serviceRef (" + serviceName + ") == null");
            }
            String operation = (String)parameters.get(SERVICE_OPERATION_NAME);
            FaultHandler handler = new FaultHandler();
            Exchange exchangeIn = operation != null ? serviceRef.createExchange(operation, (ExchangeHandler)handler) : serviceRef.createExchange((ExchangeHandler)handler);
            Context contextIn = exchangeIn.getContext();
            for (Map.Entry<String, Object> entry : parameters.entrySet()) {
                contextIn.setProperty(entry.getKey(), entry.getValue(), Scope.IN);
            }
            Message messageIn = exchangeIn.createMessage();
            String messageContentInName = this.getMessageContentInName();
            Object messageContentIn = parameters.get(messageContentInName);
            if (messageContentIn != null) {
                messageIn.setContent(messageContentIn);
            }
            if (ExchangePattern.IN_OUT.equals((Object)exchangeIn.getContract().getConsumerOperation().getExchangePattern())) {
                exchangeIn.send(messageIn);
                Exchange exchangeOut = handler.waitForOut();
                Message messageOut = exchangeOut.getMessage();
                Object messageContentOut = messageOut.getContent();
                String messageContentOutName = this.getMessageContentOutName();
                results.put(messageContentOutName, messageContentOut);
                Context contextOut = exchangeOut.getContext();
                for (Property property : contextOut.getProperties(Scope.OUT)) {
                    results.put(property.getName(), property.getValue());
                }
            } else {
                exchangeIn.send(messageIn);
            }
            fault = handler.getFault();
        }
        catch (Throwable t) {
            LOGGER.error((Object)t);
            fault = t;
        }
        if (fault != null) {
            String faultEventType;
            String faultResultName = this.getFaultResultName(parameters);
            if (faultResultName != null) {
                results.put(faultResultName, fault);
            }
            if ((faultEventType = this.getFaultEventType(parameters)) != null) {
                manager.signalEvent(faultEventType, fault, task.getProcessInstanceId());
            }
            if (this.completeAfterFault(parameters)) {
                manager.completeTask(task.getId(), results);
            }
        } else {
            manager.completeTask(task.getId(), results);
        }
    }

    private QName getServiceName(Map<String, Object> parameters) {
        String tns;
        QName serviceName = null;
        Object p = parameters.get(SERVICE_NAME);
        if (p instanceof QName) {
            serviceName = (QName)p;
        } else if (p instanceof String) {
            serviceName = XMLHelper.createQName((String)((String)p));
        }
        if (serviceName != null && Strings.trimToNull((String)serviceName.getNamespaceURI()) == null && (tns = this.getTargetNamespace()) != null) {
            serviceName = XMLHelper.createQName((String)tns, (String)serviceName.getLocalPart());
        }
        return serviceName;
    }

    private String getFaultResultName(Map<String, Object> parameters) {
        Object p = parameters.get(FAULT_RESULT_NAME);
        if (p != null) {
            return Strings.trimToNull((String)String.valueOf(p));
        }
        return null;
    }

    private String getFaultEventType(Map<String, Object> parameters) {
        Object p = parameters.get(FAULT_EVENT_TYPE);
        if (p != null) {
            return Strings.trimToNull((String)String.valueOf(p));
        }
        return null;
    }

    private boolean completeAfterFault(Map<String, Object> parameters) {
        Object p = parameters.get(COMPLETE_AFTER_FAULT);
        if (p != null) {
            if (p instanceof Boolean) {
                return (Boolean)p;
            }
            if (p instanceof String) {
                return Boolean.valueOf(((String)p).trim());
            }
        }
        return true;
    }

    private static final class FaultHandler
    extends SynchronousInOutHandler {
        private Object _fault;

        private FaultHandler() {
        }

        private Object getFault() {
            return this._fault;
        }

        public void handleFault(Exchange exchange) {
            this._fault = exchange.getMessage().getContent();
            super.handleFault(exchange);
        }
    }
}

