/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.remote.cluster;

import java.io.IOException;
import java.util.WeakHashMap;
import org.switchyard.remote.RemoteEndpoint;
import org.switchyard.remote.RemoteInvoker;
import org.switchyard.remote.RemoteMessage;
import org.switchyard.remote.RemoteMessages;
import org.switchyard.remote.RemoteRegistry;
import org.switchyard.remote.cluster.LoadBalanceStrategy;
import org.switchyard.remote.cluster.RoundRobinStrategy;
import org.switchyard.remote.http.HttpInvoker;

public class ClusteredInvoker
implements RemoteInvoker {
    private LoadBalanceStrategy _loadBalancer;
    private WeakHashMap<String, HttpInvoker> _invokers = new WeakHashMap();

    public ClusteredInvoker(RemoteRegistry registry) {
        this(registry, new RoundRobinStrategy());
    }

    public ClusteredInvoker(RemoteRegistry registry, LoadBalanceStrategy loadBalancer) {
        this._loadBalancer = loadBalancer;
        this._loadBalancer.setRegistry(registry);
    }

    @Override
    public RemoteMessage invoke(RemoteMessage request) throws IOException {
        RemoteEndpoint ep = this._loadBalancer.selectEndpoint(request.getService());
        if (ep == null) {
            throw RemoteMessages.MESSAGES.noRemoteEndpointFound(request.getService().toString());
        }
        return this.getInvoker(ep.getEndpoint()).invoke(request);
    }

    private synchronized HttpInvoker getInvoker(String endpoint) {
        HttpInvoker invoker = this._invokers.get(endpoint);
        if (invoker == null) {
            invoker = new HttpInvoker(endpoint);
            this._invokers.put(endpoint, invoker);
        }
        return invoker;
    }
}

