/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.transform.internal;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.switchyard.common.xml.QNameUtil;
import org.switchyard.metadata.JavaTypes;
import org.switchyard.transform.BaseTransformer;
import org.switchyard.transform.Transformer;
import org.switchyard.transform.internal.TransformMessages;
import org.switchyard.transform.internal.TransformerTypes;

public final class TransformerUtil {
    private static final Logger LOGGER = Logger.getLogger(TransformerUtil.class);
    private static final QName OBJECT_TYPE = JavaTypes.toMessageType(Object.class);

    private TransformerUtil() {
    }

    public static Transformer<?, ?> newTransformer(Class<?> clazz, QName from, QName to) {
        return TransformerUtil.newTransformers(clazz, from, to).iterator().next();
    }

    public static Collection<Transformer<?, ?>> newTransformers(Class<?> clazz, QName from, QName to) {
        Object transformerObject;
        if (!TransformerUtil.isTransformer(clazz)) {
            throw TransformMessages.MESSAGES.invalidTransformerClass(clazz.getName());
        }
        try {
            transformerObject = clazz.newInstance();
        }
        catch (Exception e) {
            throw TransformMessages.MESSAGES.errorConstructingTransformer(clazz.getName(), e);
        }
        return TransformerUtil.newTransformers(transformerObject, from, to);
    }

    public static Collection<Transformer<?, ?>> newTransformers(Object transformerObject, QName from, QName to) {
        Method[] publicMethods;
        boolean fromIsWild = TransformerUtil.isWildcardType(from);
        boolean toIsWild = TransformerUtil.isWildcardType(to);
        ArrayList transformers = new ArrayList();
        for (Method publicMethod : publicMethods = transformerObject.getClass().getMethods()) {
            org.switchyard.annotations.Transformer transformerAnno = publicMethod.getAnnotation(org.switchyard.annotations.Transformer.class);
            if (transformerAnno == null) continue;
            TransformerMethod transformerMethod = TransformerUtil.toTransformerMethod(publicMethod, transformerAnno);
            if (!fromIsWild && !transformerMethod.getFrom().equals(from) || !toIsWild && !transformerMethod.getTo().equals(to)) continue;
            transformers.add(TransformerUtil.newTransformer(transformerObject, transformerMethod.getMethod(), transformerMethod.getFrom(), transformerMethod.getTo()));
        }
        if (transformerObject instanceof Transformer) {
            Transformer transformer = (Transformer)transformerObject;
            QName transFrom = transformer.getFrom();
            QName transTo = transformer.getTo();
            if (transFrom.equals(OBJECT_TYPE) && transTo.equals(OBJECT_TYPE)) {
                transformers.add(transformer);
            } else if ((fromIsWild || transFrom.equals(from)) && (toIsWild || transTo.equals(to))) {
                transformers.add(transformer);
            } else if (TransformerUtil.isAssignableFrom(transFrom, from) && TransformerUtil.isAssignableFrom(transTo, to)) {
                transformers.add(transformer);
            }
            if (!fromIsWild) {
                transformer.setFrom(from);
            }
            if (!toIsWild) {
                transformer.setTo(to);
            }
        }
        if (transformers.isEmpty()) {
            throw TransformMessages.MESSAGES.classDoesNotSupportTransformation(transformerObject.getClass().getName(), from.toString(), to.toString());
        }
        return transformers;
    }

    public static List<TransformerTypes> listTransformations(Class<?> clazz) {
        Method[] publicMethods;
        Object transformerObject;
        ArrayList<TransformerTypes> transformations = new ArrayList<TransformerTypes>();
        try {
            transformerObject = clazz.newInstance();
        }
        catch (Exception e) {
            throw TransformMessages.MESSAGES.errorConstructingTransformer(clazz.getName(), e);
        }
        if (transformerObject instanceof Transformer) {
            QName from = ((Transformer)transformerObject).getFrom();
            QName to = ((Transformer)transformerObject).getTo();
            if (from != null && to != null) {
                TransformerTypes transformerTypes = new TransformerTypes(from, to);
                transformations.add(transformerTypes);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("added: " + transformerTypes));
                }
            }
        }
        for (Method publicMethod : publicMethods = clazz.getMethods()) {
            org.switchyard.annotations.Transformer transformerAnno = publicMethod.getAnnotation(org.switchyard.annotations.Transformer.class);
            if (transformerAnno == null) continue;
            TransformerMethod transformerMethod = TransformerUtil.toTransformerMethod(publicMethod, transformerAnno);
            TransformerTypes transformerTypes = new TransformerTypes(transformerMethod.getFrom(), transformerMethod.getTo());
            transformations.add(transformerTypes);
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug((Object)("added: " + transformerTypes));
        }
        Collections.sort(transformations, new TransformerTypesComparator());
        if (LOGGER.isDebugEnabled()) {
            for (TransformerTypes transformerTypes : transformations) {
                LOGGER.debug((Object)("sorted: " + transformerTypes));
            }
        }
        return transformations;
    }

    public static boolean isTransformer(Class<?> clazz) {
        Method[] publicMethods;
        if (clazz.isInterface()) {
            return false;
        }
        if (clazz.isAnnotation()) {
            return false;
        }
        if (Modifier.isAbstract(clazz.getModifiers())) {
            return false;
        }
        try {
            clazz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        if (Transformer.class.isAssignableFrom(clazz)) {
            return true;
        }
        for (Method publicMethod : publicMethods = clazz.getMethods()) {
            if (!publicMethod.isAnnotationPresent(org.switchyard.annotations.Transformer.class)) continue;
            return true;
        }
        return false;
    }

    private static Transformer newTransformer(final Object transformerObject, final Method publicMethod, QName from, QName to) {
        BaseTransformer transformer = new BaseTransformer(from, to){

            public Object transform(Object from) {
                try {
                    return publicMethod.invoke(transformerObject, from);
                }
                catch (InvocationTargetException e) {
                    throw TransformMessages.MESSAGES.errorExecutingTransformerMethod(publicMethod.getName(), publicMethod.getDeclaringClass().getName(), e.getCause());
                }
                catch (Exception e) {
                    throw TransformMessages.MESSAGES.errorExecutingTransformerMethod(publicMethod.getName(), publicMethod.getDeclaringClass().getName(), e);
                }
            }

            public Class<?> getFromType() {
                return publicMethod.getParameterTypes()[0];
            }

            public Class<?> getToType() {
                return publicMethod.getReturnType();
            }
        };
        return transformer;
    }

    private static boolean isAssignableFrom(QName a, QName b) {
        if (QNameUtil.isJavaMessageType((QName)a) && QNameUtil.isJavaMessageType((QName)b)) {
            Class aType = QNameUtil.toJavaMessageType((QName)a);
            Class bType = QNameUtil.toJavaMessageType((QName)b);
            if (aType == null || bType == null) {
                return false;
            }
            return aType.isAssignableFrom(bType);
        }
        return false;
    }

    private static boolean isWildcardType(QName type) {
        return type.toString().equals("*");
    }

    private static TransformerMethod toTransformerMethod(Method publicMethod, org.switchyard.annotations.Transformer transformerAnno) {
        Class<?>[] params = publicMethod.getParameterTypes();
        if (params.length != 1) {
            throw TransformMessages.MESSAGES.invalidTransformerMethodParameter(publicMethod.getName(), publicMethod.getDeclaringClass().getName());
        }
        Class<?> fromType = params[0];
        Class<?> toType = publicMethod.getReturnType();
        if (toType == null) {
            throw TransformMessages.MESSAGES.invalidTransformerMethodResult(publicMethod.getName(), publicMethod.getDeclaringClass().getName());
        }
        QName from = !transformerAnno.from().trim().equals("") ? QName.valueOf(transformerAnno.from().trim()) : JavaTypes.toMessageType(fromType);
        QName to = !transformerAnno.to().trim().equals("") ? QName.valueOf(transformerAnno.to().trim()) : JavaTypes.toMessageType(toType);
        return new TransformerMethod(from, to, publicMethod);
    }

    private static final class TransformerTypesComparator
    implements Comparator<TransformerTypes>,
    Serializable {
        private TransformerTypesComparator() {
        }

        @Override
        public int compare(TransformerTypes tt1, TransformerTypes tt2) {
            int c = String.valueOf(tt1.getFrom()).compareTo(String.valueOf(tt2.getFrom()));
            if (c == 0 && (c = String.valueOf(tt1.getTo()).compareTo(String.valueOf(tt2.getTo()))) == 0 && tt1 instanceof TransformerMethod && tt2 instanceof TransformerMethod) {
                TransformerMethod tm1 = (TransformerMethod)tt1;
                TransformerMethod tm2 = (TransformerMethod)tt2;
                c = String.valueOf(tm1.getMethod()).compareTo(String.valueOf(tm2.getMethod()));
            }
            return c;
        }
    }

    private static class TransformerMethod
    extends TransformerTypes {
        private Method _method;

        TransformerMethod(QName from, QName to, Method publicMethod) {
            super(from, to);
            this._method = publicMethod;
        }

        private Method getMethod() {
            return this._method;
        }

        @Override
        public String toString() {
            return String.format("%s [from=%s, to=%s, method=%s]", this.getClass().getSimpleName(), this.getFrom(), this.getTo(), this.getMethod());
        }
    }
}

