/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.transform.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.jboss.logging.Logger;
import org.switchyard.ServiceDomain;
import org.switchyard.common.cdi.CDIUtil;
import org.switchyard.common.type.Classes;
import org.switchyard.config.model.ModelPuller;
import org.switchyard.config.model.transform.TransformModel;
import org.switchyard.config.model.transform.TransformsModel;
import org.switchyard.transform.Transformer;
import org.switchyard.transform.TransformerRegistry;
import org.switchyard.transform.config.model.JavaTransformModel;
import org.switchyard.transform.internal.DuplicateTransformerException;
import org.switchyard.transform.internal.TransformMessages;
import org.switchyard.transform.internal.TransformerFactory;
import org.switchyard.transform.internal.TransformerFactoryClass;
import org.switchyard.transform.internal.TransformerUtil;
import org.switchyard.transform.jaxb.internal.JAXBTransformerFactory;

public class TransformerRegistryLoader {
    private static Logger _log = Logger.getLogger(TransformerRegistryLoader.class);
    public static final String TRANSFORMS_XML = "META-INF/switchyard/transforms.xml";
    private List<Transformer<?, ?>> _transformers = new LinkedList();
    private TransformerRegistry _transformerRegistry;
    private Map<Class<?>, TransformerFactory<?>> _transformerFactories = new HashMap();
    private ServiceDomain _serviceDomain;
    private List<CreationalContext<?>> _cdiCreationalContexts = new LinkedList();

    public TransformerRegistryLoader(ServiceDomain domain) {
        if (domain == null) {
            throw TransformMessages.MESSAGES.nullServiceDomainArgument();
        }
        this._serviceDomain = domain;
        if (this._serviceDomain.getTransformerRegistry() == null) {
            throw TransformMessages.MESSAGES.nullTransformerRegistryArgument();
        }
        this._transformerRegistry = this._serviceDomain.getTransformerRegistry();
    }

    public TransformerRegistryLoader(TransformerRegistry transformerRegistry) {
        if (transformerRegistry == null) {
            throw TransformMessages.MESSAGES.nullTransformerRegistryArgument();
        }
        this._transformerRegistry = transformerRegistry;
        this._serviceDomain = null;
    }

    public void registerTransformers(TransformsModel transforms) throws DuplicateTransformerException {
        this.registerTransformers(transforms, true);
    }

    public void registerTransformers(TransformsModel transforms, boolean failOnError) throws DuplicateTransformerException {
        if (transforms == null) {
            return;
        }
        try {
            for (TransformModel transformModel : transforms.getTransforms()) {
                Collection<Transformer<?, ?>> transformers = this.newTransformers(transformModel);
                for (Transformer<?, ?> transformer : transformers) {
                    if (this._transformerRegistry.hasTransformer(transformer.getFrom(), transformer.getTo())) {
                        Transformer registeredTransformer = this._transformerRegistry.getTransformer(transformer.getFrom(), transformer.getTo());
                        boolean test = false;
                        for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
                            if (!ste.getClassName().startsWith("org.switchyard.test.")) continue;
                            test = true;
                            break;
                        }
                        String msg = "Failed to register Transformer '" + this.toDescription(transformer) + "'.  A Transformer for these types is already registered: '" + this.toDescription(registeredTransformer) + "'.";
                        if (test) {
                            _log.trace((Object)msg);
                            continue;
                        }
                        if (failOnError) {
                            throw new DuplicateTransformerException(msg);
                        }
                        _log.debug((Object)msg);
                        continue;
                    }
                    _log.debug((Object)("Adding transformer => From: " + transformer.getFrom() + ", To:" + transformer.getTo()));
                    this._transformerRegistry.addTransformer(transformer);
                    this._transformers.add(transformer);
                }
            }
        }
        catch (DuplicateTransformerException e) {
            throw e;
        }
        catch (RuntimeException e) {
            this.unregisterTransformers();
            throw e;
        }
    }

    public void unregisterTransformers() {
        for (Transformer<?, ?> transformer : this._transformers) {
            this._transformerRegistry.removeTransformer(transformer);
            JAXBTransformerFactory.removeContext(transformer);
        }
        for (CreationalContext creationalContext : this._cdiCreationalContexts) {
            creationalContext.release();
        }
        this._cdiCreationalContexts.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadOOTBTransforms() {
        try {
            List<URL> resources = this.getResources(TRANSFORMS_XML);
            for (URL resource : resources) {
                InputStream configStream = resource.openStream();
                try {
                    TransformsModel transformsModel = (TransformsModel)new ModelPuller().pull(configStream);
                    this.registerTransformers(transformsModel, false);
                }
                catch (DuplicateTransformerException e) {
                    _log.debug((Object)e.getMessage());
                }
                finally {
                    configStream.close();
                }
            }
        }
        catch (IOException e) {
            throw TransformMessages.MESSAGES.errorReadingTransformerConfig(TRANSFORMS_XML, e);
        }
    }

    public Transformer<?, ?> newTransformer(TransformModel transformModel) {
        return this.newTransformers(transformModel).iterator().next();
    }

    public Collection<Transformer<?, ?>> newTransformers(TransformModel transformModel) {
        Collection<Transformer<?, ?>> transformers = null;
        if (transformModel instanceof JavaTransformModel) {
            JavaTransformModel javaTransformModel = (JavaTransformModel)JavaTransformModel.class.cast(transformModel);
            String bean = javaTransformModel.getBean();
            if (bean != null) {
                BeanManager beanManager = CDIUtil.lookupBeanManager();
                if (beanManager == null) {
                    throw TransformMessages.MESSAGES.cdiBeanManagerNotFound();
                }
                Object transformer = null;
                Set beans = beanManager.getBeans(bean);
                if (beans != null && !beans.isEmpty()) {
                    Bean target = (Bean)beans.iterator().next();
                    CreationalContext context = beanManager.createCreationalContext((Contextual)target);
                    transformer = beanManager.getReference(target, Object.class, context);
                    this._cdiCreationalContexts.add(context);
                }
                if (transformer == null) {
                    throw TransformMessages.MESSAGES.beanNotFoundInCDIRegistry(bean);
                }
                transformers = TransformerUtil.newTransformers(transformer, transformModel.getFrom(), transformModel.getTo());
            } else {
                String className = ((JavaTransformModel)transformModel).getClazz();
                if (className == null) {
                    throw TransformMessages.MESSAGES.beanOrClassMustBeSpecified();
                }
                Class<?> transformClass = this.getClass(className);
                if (transformClass == null) {
                    throw TransformMessages.MESSAGES.unableToLoadTransformerClass(className);
                }
                transformers = TransformerUtil.newTransformers(transformClass, transformModel.getFrom(), transformModel.getTo());
            }
        } else {
            TransformerFactory<?> factory = this.getTransformerFactory(transformModel);
            transformers = new ArrayList();
            transformers.add(factory.newTransformer(this._serviceDomain, transformModel));
        }
        if (transformers == null || transformers.isEmpty()) {
            throw TransformMessages.MESSAGES.unknownTransformModel(transformModel.getClass().getName());
        }
        return transformers;
    }

    protected List<URL> getResources(String path) throws IOException {
        return Classes.getResources((String)path, this.getClass());
    }

    protected Class<?> getClass(String className) {
        return Classes.forName((String)className, TransformerUtil.class);
    }

    private String toDescription(Transformer<?, ?> transformer) {
        return transformer.getClass().getName() + "(" + transformer.getFrom() + ", " + transformer.getTo() + ")";
    }

    private TransformerFactory<?> getTransformerFactory(TransformModel transformModel) {
        Class<? extends TransformerFactory> factoryClass;
        TransformerFactoryClass transformerFactoryClass = transformModel.getClass().getAnnotation(TransformerFactoryClass.class);
        if (transformerFactoryClass == null) {
            TransformMessages.MESSAGES.transformModelNotAnnotated(transformModel.getClass().getName());
        }
        if (!TransformerFactory.class.isAssignableFrom(factoryClass = transformerFactoryClass.value())) {
            TransformMessages.MESSAGES.invalidTransformerFactory(TransformerFactory.class.getName());
        }
        try {
            if (!this._transformerFactories.containsKey(factoryClass)) {
                TransformerFactory factory = factoryClass.newInstance();
                this._transformerFactories.put(factoryClass, factory);
            }
            return this._transformerFactories.get(factoryClass);
        }
        catch (ClassCastException e) {
            throw TransformMessages.MESSAGES.failedCreateInstanceofTransformerFactory(factoryClass.getName());
        }
        catch (IllegalArgumentException iae) {
            throw TransformMessages.MESSAGES.failedCreateInstanceofTransformerFactory(factoryClass.getName());
        }
        catch (NullPointerException npe) {
            throw TransformMessages.MESSAGES.failedCreateInstanceofTransformerFactory(factoryClass.getName());
        }
        catch (InstantiationException ie) {
            throw TransformMessages.MESSAGES.failedCreateInstanceofTransformerFactory(factoryClass.getName());
        }
        catch (IllegalAccessException iae) {
            throw TransformMessages.MESSAGES.failedCreateInstanceofTransformerFactory(factoryClass.getName());
        }
    }
}

