/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.validate.xml;

import java.io.IOException;
import javax.xml.namespace.QName;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.log4j.Logger;
import org.switchyard.Message;
import org.switchyard.common.type.Classes;
import org.switchyard.config.model.Scannable;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.validate.BaseValidator;
import org.switchyard.validate.config.model.XmlSchemaType;
import org.switchyard.validate.config.model.XmlValidateModel;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

@Scannable(value=false)
public class XmlValidator
extends BaseValidator<Message> {
    private static final Logger LOGGER = Logger.getLogger(XmlValidator.class);
    private XmlSchemaType _schemaType;
    private String _schemaTypeUri;
    private String _schemaFile;
    private boolean _failOnWarning;

    public XmlValidator(QName name, XmlValidateModel model) {
        super(name);
        this._schemaType = model.getSchemaType();
        this._schemaFile = model.getSchemaFile();
        if (this._schemaType == null || this._schemaFile == null) {
            throw new SwitchYardException("Could not instantiate XmlValidator: both of schemaType and schemaFile must be specified.");
        }
        switch (this._schemaType) {
            case DTD: {
                this._schemaTypeUri = "http://www.w3.org/TR/REC-xml";
                break;
            }
            case XML_SCHEMA: {
                this._schemaTypeUri = "http://www.w3.org/2001/XMLSchema";
                break;
            }
            case RELAX_NG: {
                this._schemaTypeUri = "http://relaxng.org/ns/structure/1.0";
                break;
            }
            default: {
                throw new SwitchYardException("Could not instantiate XmlValidator: schemaType '" + (Object)((Object)this._schemaType) + "' is invalid." + "It must be the one of " + XmlSchemaType.values() + ".");
            }
        }
        this._failOnWarning = model.failOnWarning();
    }

    public boolean validate(Message msg) {
        if ("http://www.w3.org/2001/XMLSchema".equals(this._schemaTypeUri) || "http://relaxng.org/ns/structure/1.0".equals(this._schemaTypeUri)) {
            SchemaFactory schemaFactory = SchemaFactory.newInstance(this._schemaTypeUri);
            try {
                Schema schema = schemaFactory.newSchema(new StreamSource(Classes.getResourceAsStream((String)this._schemaFile)));
                Validator validator = schema.newValidator();
                validator.setErrorHandler(new XmlValidationErrorHandler(this._failOnWarning));
                validator.validate((Source)msg.getContent(DOMSource.class));
            }
            catch (SAXException e) {
                throw new SwitchYardException("Error during validation with '" + this._schemaFile + "' as '" + (Object)((Object)this._schemaType) + "'.", (Throwable)e);
            }
            catch (IOException ioe) {
                throw new SwitchYardException("Error during validation with '" + this._schemaFile + "' as '" + (Object)((Object)this._schemaType) + "'.", (Throwable)ioe);
            }
        } else if ("http://www.w3.org/TR/REC-xml".equals(this._schemaTypeUri)) {
            try {
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("doctype-system", this._schemaFile);
                transformer.setErrorListener(new XmlValidationErrorListener(this._failOnWarning));
                transformer.transform((Source)msg.getContent(DOMSource.class), new StreamResult());
            }
            catch (Exception e) {
                throw new SwitchYardException("Error during validation with '" + this._schemaFile + "' as '" + (Object)((Object)this._schemaType) + "'.", (Throwable)e);
            }
        } else {
            throw new SwitchYardException("Unknown XML Schema type '" + (Object)((Object)this._schemaType) + "', should be one of '" + XmlSchemaType.values() + "'.");
        }
        return true;
    }

    private class XmlValidationErrorListener
    implements ErrorListener {
        private boolean _failOnWarning;

        public XmlValidationErrorListener(boolean failOnWarning) {
            this._failOnWarning = failOnWarning;
        }

        @Override
        public void fatalError(TransformerException e) throws TransformerException {
            throw e;
        }

        @Override
        public void error(TransformerException e) throws TransformerException {
            throw e;
        }

        @Override
        public void warning(TransformerException e) throws TransformerException {
            if (this._failOnWarning) {
                throw e;
            }
            LOGGER.warn((Object)("Warning during validation with '" + XmlValidator.this._schemaFile + "' as '" + (Object)((Object)XmlValidator.this._schemaType) + "'"), (Throwable)e);
        }
    }

    private class XmlValidationErrorHandler
    extends DefaultHandler {
        private boolean _failOnWarning;

        public XmlValidationErrorHandler(boolean failOnWarning) {
            this._failOnWarning = failOnWarning;
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            throw e;
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            if (this._failOnWarning) {
                throw e;
            }
            LOGGER.warn((Object)("Warning during validation with '" + XmlValidator.this._schemaFile + "' as '" + (Object)((Object)XmlValidator.this._schemaType) + "'"), (Throwable)e);
        }
    }
}

