/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.adminapi.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.adminapi.impl.TestVDBUtility;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.adminapi.impl.VDBMetadataParser;
import org.teiid.core.util.UnitTestUtil;
import org.xml.sax.SAXException;

public class TestVDBMetadataParser {
    @Test
    public void testParseVDB() throws Exception {
        FileInputStream in = new FileInputStream(UnitTestUtil.getTestDataPath() + "/parser-test-vdb.xml");
        VDBMetadataParser.validate((InputStream)in);
        in = new FileInputStream(UnitTestUtil.getTestDataPath() + "/parser-test-vdb.xml");
        VDBMetaData vdb = VDBMetadataParser.unmarshell((InputStream)in);
        TestVDBUtility.validateVDB(vdb);
    }

    @Test
    public void testExcludeImported() throws Exception {
        VDBMetaData metadata = TestVDBUtility.buildVDB();
        Assert.assertNotNull((Object)metadata.getModel("model-one"));
        metadata.setImportedModels(Collections.singleton("model-one"));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        VDBMetadataParser.marshell((VDBMetaData)metadata, (OutputStream)baos);
        baos.close();
        VDBMetaData parsed = VDBMetadataParser.unmarshell((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        Assert.assertNull((Object)parsed.getModel("model-one"));
    }

    @Test(expected=SAXException.class)
    public void testModelNameUniqueness() throws Exception {
        FileInputStream in = new FileInputStream(UnitTestUtil.getTestDataPath() + "/model-not-unique-vdb.xml");
        VDBMetadataParser.validate((InputStream)in);
    }
}

