/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dialect;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.LockMode;
import org.hibernate.boot.TempTableDdlTransactionHandling;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.NoArgSQLFunction;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.dialect.function.VarArgsSQLFunction;
import org.hibernate.hql.spi.id.IdTableSupport;
import org.hibernate.hql.spi.id.IdTableSupportStandardImpl;
import org.hibernate.hql.spi.id.MultiTableBulkIdStrategy;
import org.hibernate.hql.spi.id.local.AfterUseAction;
import org.hibernate.hql.spi.id.local.LocalTemporaryTableBulkIdStrategy;
import org.hibernate.type.BigDecimalType;
import org.hibernate.type.BigIntegerType;
import org.hibernate.type.BlobType;
import org.hibernate.type.CharacterType;
import org.hibernate.type.ClobType;
import org.hibernate.type.DateType;
import org.hibernate.type.DoubleType;
import org.hibernate.type.FloatType;
import org.hibernate.type.IntegerType;
import org.hibernate.type.LongType;
import org.hibernate.type.ObjectType;
import org.hibernate.type.StringType;
import org.hibernate.type.TimeType;
import org.hibernate.type.TimestampType;
import org.hibernate.type.Type;

public class TeiidDialect
extends Dialect {
    private static DoubleType DOUBLE = DoubleType.INSTANCE;
    private static StringType STRING = StringType.INSTANCE;
    private static BigDecimalType BIG_DECIMAL = BigDecimalType.INSTANCE;
    private static FloatType FLOAT = FloatType.INSTANCE;
    private static IntegerType INTEGER = IntegerType.INSTANCE;
    private static LongType LONG = LongType.INSTANCE;
    private static CharacterType CHARACTER = CharacterType.INSTANCE;
    private static BigIntegerType BIG_INTEGER = BigIntegerType.INSTANCE;
    private static DateType DATE = DateType.INSTANCE;
    private static TimeType TIME = TimeType.INSTANCE;
    private static TimestampType TIMESTAMP = TimestampType.INSTANCE;
    private static BlobType BLOB = BlobType.INSTANCE;
    private static ClobType CLOB = ClobType.INSTANCE;
    private static ObjectType OBJECT = ObjectType.INSTANCE;

    public TeiidDialect() {
        this.registerColumnType(1, "char");
        this.registerColumnType(12, "string");
        this.registerColumnType(-7, "boolean");
        this.registerColumnType(-6, "byte");
        this.registerColumnType(5, "short");
        this.registerColumnType(4, "integer");
        this.registerColumnType(-5, "long");
        this.registerColumnType(7, "float");
        this.registerColumnType(6, "float");
        this.registerColumnType(8, "double");
        this.registerColumnType(2, "bigdecimal");
        this.registerColumnType(91, "date");
        this.registerColumnType(92, "time");
        this.registerColumnType(93, "timestamp");
        this.registerColumnType(2004, "blob");
        this.registerColumnType(-3, "blob");
        this.registerColumnType(2005, "clob");
        this.registerColumnType(2000, "object");
        this.registerFunction("acos", (SQLFunction)new StandardSQLFunction("acos", (Type)DOUBLE));
        this.registerFunction("asin", (SQLFunction)new StandardSQLFunction("asin", (Type)DOUBLE));
        this.registerFunction("atan", (SQLFunction)new StandardSQLFunction("atan", (Type)DOUBLE));
        this.registerFunction("atan2", (SQLFunction)new StandardSQLFunction("atan2", (Type)DOUBLE));
        this.registerFunction("ceil", (SQLFunction)new StandardSQLFunction("ceiling"));
        this.registerFunction("cos", (SQLFunction)new StandardSQLFunction("cos", (Type)DOUBLE));
        this.registerFunction("cot", (SQLFunction)new StandardSQLFunction("cot", (Type)DOUBLE));
        this.registerFunction("degrees", (SQLFunction)new StandardSQLFunction("degrees", (Type)DOUBLE));
        this.registerFunction("exp", (SQLFunction)new StandardSQLFunction("exp", (Type)DOUBLE));
        this.registerFunction("floor", (SQLFunction)new StandardSQLFunction("floor"));
        this.registerFunction("formatbigdecimal", (SQLFunction)new StandardSQLFunction("formatbigdecimal", (Type)STRING));
        this.registerFunction("formatbiginteger", (SQLFunction)new StandardSQLFunction("formatbiginteger", (Type)STRING));
        this.registerFunction("formatdouble", (SQLFunction)new StandardSQLFunction("formatdouble", (Type)STRING));
        this.registerFunction("formatfloat", (SQLFunction)new StandardSQLFunction("formatfloat", (Type)STRING));
        this.registerFunction("formatinteger", (SQLFunction)new StandardSQLFunction("formatinteger", (Type)STRING));
        this.registerFunction("formatlong", (SQLFunction)new StandardSQLFunction("formatlong", (Type)STRING));
        this.registerFunction("log", (SQLFunction)new StandardSQLFunction("log", (Type)DOUBLE));
        this.registerFunction("mod", (SQLFunction)new StandardSQLFunction("mod"));
        this.registerFunction("parsebigdecimal", (SQLFunction)new StandardSQLFunction("parsebigdecimal", (Type)BIG_DECIMAL));
        this.registerFunction("parsebiginteger", (SQLFunction)new StandardSQLFunction("parsebiginteger", (Type)BIG_INTEGER));
        this.registerFunction("parsedouble", (SQLFunction)new StandardSQLFunction("parsedouble", (Type)DOUBLE));
        this.registerFunction("parsefloat", (SQLFunction)new StandardSQLFunction("parsefloat", (Type)FLOAT));
        this.registerFunction("parseinteger", (SQLFunction)new StandardSQLFunction("parseinteger", (Type)INTEGER));
        this.registerFunction("parselong", (SQLFunction)new StandardSQLFunction("parselong", (Type)LONG));
        this.registerFunction("pi", (SQLFunction)new StandardSQLFunction("pi", (Type)DOUBLE));
        this.registerFunction("power", (SQLFunction)new StandardSQLFunction("power", (Type)DOUBLE));
        this.registerFunction("radians", (SQLFunction)new StandardSQLFunction("radians", (Type)DOUBLE));
        this.registerFunction("round", (SQLFunction)new StandardSQLFunction("round"));
        this.registerFunction("sign", (SQLFunction)new StandardSQLFunction("sign", (Type)INTEGER));
        this.registerFunction("sin", (SQLFunction)new StandardSQLFunction("sin", (Type)DOUBLE));
        this.registerFunction("tan", (SQLFunction)new StandardSQLFunction("tan", (Type)DOUBLE));
        this.registerFunction("ascii", (SQLFunction)new StandardSQLFunction("ascii", (Type)INTEGER));
        this.registerFunction("chr", (SQLFunction)new StandardSQLFunction("chr", (Type)CHARACTER));
        this.registerFunction("char", (SQLFunction)new StandardSQLFunction("char", (Type)CHARACTER));
        this.registerFunction("concat", (SQLFunction)new VarArgsSQLFunction((Type)STRING, "", "||", ""));
        this.registerFunction("initcap", (SQLFunction)new StandardSQLFunction("initcap", (Type)STRING));
        this.registerFunction("insert", (SQLFunction)new StandardSQLFunction("insert", (Type)STRING));
        this.registerFunction("lcase", (SQLFunction)new StandardSQLFunction("lcase", (Type)STRING));
        this.registerFunction("left", (SQLFunction)new StandardSQLFunction("left", (Type)STRING));
        this.registerFunction("locate", (SQLFunction)new StandardSQLFunction("locate", (Type)INTEGER));
        this.registerFunction("lpad", (SQLFunction)new StandardSQLFunction("lpad", (Type)STRING));
        this.registerFunction("ltrim", (SQLFunction)new StandardSQLFunction("ltrim", (Type)STRING));
        this.registerFunction("repeat", (SQLFunction)new StandardSQLFunction("repeat", (Type)STRING));
        this.registerFunction("replace", (SQLFunction)new StandardSQLFunction("replace", (Type)STRING));
        this.registerFunction("right", (SQLFunction)new StandardSQLFunction("right", (Type)STRING));
        this.registerFunction("rpad", (SQLFunction)new StandardSQLFunction("rpad", (Type)STRING));
        this.registerFunction("rtrim", (SQLFunction)new StandardSQLFunction("rtrim", (Type)STRING));
        this.registerFunction("substring", (SQLFunction)new StandardSQLFunction("substring", (Type)STRING));
        this.registerFunction("translate", (SQLFunction)new StandardSQLFunction("translate", (Type)STRING));
        this.registerFunction("ucase", (SQLFunction)new StandardSQLFunction("ucase", (Type)STRING));
        this.registerFunction("curdate", (SQLFunction)new NoArgSQLFunction("curdate", (Type)DATE));
        this.registerFunction("curtime", (SQLFunction)new NoArgSQLFunction("curtime", (Type)TIME));
        this.registerFunction("now", (SQLFunction)new NoArgSQLFunction("now", (Type)TIMESTAMP));
        this.registerFunction("dayname", (SQLFunction)new StandardSQLFunction("dayname", (Type)STRING));
        this.registerFunction("dayofmonth", (SQLFunction)new StandardSQLFunction("dayofmonth", (Type)INTEGER));
        this.registerFunction("dayofweek", (SQLFunction)new StandardSQLFunction("dayofweek", (Type)INTEGER));
        this.registerFunction("dayofyear", (SQLFunction)new StandardSQLFunction("dayofyear", (Type)INTEGER));
        this.registerFunction("formatdate", (SQLFunction)new StandardSQLFunction("formatdate", (Type)STRING));
        this.registerFunction("formattime", (SQLFunction)new StandardSQLFunction("formattime", (Type)STRING));
        this.registerFunction("formattimestamp", (SQLFunction)new StandardSQLFunction("formattimestamp", (Type)STRING));
        this.registerFunction("hour", (SQLFunction)new StandardSQLFunction("hour", (Type)INTEGER));
        this.registerFunction("minute", (SQLFunction)new StandardSQLFunction("minute", (Type)INTEGER));
        this.registerFunction("monthname", (SQLFunction)new StandardSQLFunction("monthname", (Type)STRING));
        this.registerFunction("parsedate", (SQLFunction)new StandardSQLFunction("parsedate", (Type)DATE));
        this.registerFunction("parsetime", (SQLFunction)new StandardSQLFunction("parsetime", (Type)TIME));
        this.registerFunction("parsetimestamp", (SQLFunction)new StandardSQLFunction("parsetimestamp", (Type)TIMESTAMP));
        this.registerFunction("second", (SQLFunction)new StandardSQLFunction("second", (Type)INTEGER));
        this.registerFunction("timestampcreate", (SQLFunction)new StandardSQLFunction("timestampcreate", (Type)TIMESTAMP));
        this.registerFunction("timestampAdd", (SQLFunction)new StandardSQLFunction("timestampAdd"));
        this.registerFunction("timestampDiff", (SQLFunction)new StandardSQLFunction("timestampDiff", (Type)LONG));
        this.registerFunction("week", (SQLFunction)new StandardSQLFunction("week", (Type)INTEGER));
        this.registerFunction("year", (SQLFunction)new StandardSQLFunction("year", (Type)INTEGER));
        this.registerFunction("modifytimezone", (SQLFunction)new StandardSQLFunction("modifytimezone", (Type)TIMESTAMP));
        this.registerFunction("convert", (SQLFunction)new StandardSQLFunction("convert"));
        this.registerFunction("to_bytes", (SQLFunction)new StandardSQLFunction("to_bytes", (Type)BLOB));
        this.registerFunction("to_chars", (SQLFunction)new StandardSQLFunction("to_chars", (Type)CLOB));
        this.registerFunction("from_unittime", (SQLFunction)new StandardSQLFunction("from_unittime", (Type)TIMESTAMP));
        this.registerFunction("session_id", (SQLFunction)new StandardSQLFunction("session_id", (Type)STRING));
        this.registerFunction("uuid", (SQLFunction)new StandardSQLFunction("uuid", (Type)STRING));
        this.registerFunction("unescape", (SQLFunction)new StandardSQLFunction("unescape", (Type)STRING));
        this.registerFunction("array_get", (SQLFunction)new StandardSQLFunction("array_get", (Type)OBJECT));
        this.registerFunction("array_length", (SQLFunction)new StandardSQLFunction("array_length", (Type)INTEGER));
    }

    public boolean dropConstraints() {
        return false;
    }

    public boolean hasAlterTable() {
        return false;
    }

    public boolean supportsColumnCheck() {
        return false;
    }

    public boolean supportsCascadeDelete() {
        return false;
    }

    public String getCurrentTimestampSQLFunctionName() {
        return "now";
    }

    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    public boolean supportsLimit() {
        return true;
    }

    public boolean supportsOuterJoinForUpdate() {
        return false;
    }

    public boolean supportsTableCheck() {
        return false;
    }

    public boolean supportsUnionAll() {
        return true;
    }

    public boolean supportsUnique() {
        return false;
    }

    public String toBooleanValueString(boolean arg0) {
        if (arg0) {
            return "{b'true'}";
        }
        return "{b'false'}";
    }

    public String getLimitString(String querySelect, boolean hasOffset) {
        return new StringBuffer(querySelect.length() + 20).append(querySelect).append(hasOffset ? " limit ?, ?" : " limit ?").toString();
    }

    public ResultSet getResultSet(CallableStatement ps) throws SQLException {
        boolean isResultSet = ps.execute();
        while (!isResultSet && ps.getUpdateCount() != -1) {
            isResultSet = ps.getMoreResults();
        }
        ResultSet rs = ps.getResultSet();
        return rs;
    }

    public int registerResultSetOutParameter(CallableStatement statement, int col) throws SQLException {
        return col;
    }

    public String getForUpdateNowaitString() {
        return "";
    }

    public String getForUpdateNowaitString(String aliases) {
        return "";
    }

    public String getForUpdateString() {
        return "";
    }

    public String getForUpdateString(LockMode lockMode) {
        return "";
    }

    public String getForUpdateString(String aliases) {
        return "";
    }

    public String getSelectGUIDString() {
        return "select uuid()";
    }

    public MultiTableBulkIdStrategy getDefaultMultiTableBulkIdStrategy() {
        return new LocalTemporaryTableBulkIdStrategy((IdTableSupport)new IdTableSupportStandardImpl(){

            public String getCreateIdTableCommand() {
                return "create local temporary table";
            }

            public String getDropIdTableCommand() {
                return "drop table";
            }
        }, AfterUseAction.DROP, TempTableDdlTransactionHandling.NONE);
    }
}

