/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.spi;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javax.resource.NotSupportedException;
import javax.resource.spi.XATerminator;
import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkManager;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.teiid.resource.api.XAImporter;

public class XAImporterImpl
implements XAImporter {
    private XATerminator xaTerminator;
    private WorkManager workManager;

    public XAImporterImpl(XATerminator xaTerminator, WorkManager workManager) {
        this.xaTerminator = xaTerminator;
        this.workManager = workManager;
    }

    public Transaction importTransaction(final TransactionManager transactionManager, Xid xid, int transactionTimeout) throws XAException {
        ExecutionContext ec = new ExecutionContext();
        ec.setXid(xid);
        try {
            ec.setTransactionTimeout((long)transactionTimeout);
            FutureWork<Transaction> work = new FutureWork<Transaction>(new Callable<Transaction>(){

                @Override
                public Transaction call() throws Exception {
                    return transactionManager.getTransaction();
                }
            });
            this.workManager.doWork(work, Long.MAX_VALUE, ec, null);
            return (Transaction)work.get();
        }
        catch (InterruptedException | ExecutionException | NotSupportedException | WorkException e) {
            XAException xaException = new XAException();
            xaException.initCause(e);
            throw xaException;
        }
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        this.xaTerminator.commit(xid, onePhase);
    }

    public void forget(Xid xid) throws XAException {
        this.xaTerminator.forget(xid);
    }

    public int prepare(Xid xid) throws XAException {
        return this.xaTerminator.prepare(xid);
    }

    public Xid[] recover(int flag) throws XAException {
        return this.xaTerminator.recover(flag);
    }

    public void rollback(Xid xid) throws XAException {
        this.xaTerminator.rollback(xid);
    }

    private static class FutureWork<T>
    extends FutureTask<T>
    implements Work {
        public FutureWork(Callable<T> callable) {
            super(callable);
        }

        public void release() {
        }
    }
}

