/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.a2a.server.apps.grpc;

import io.a2a.server.PublicAgentCard;
import io.a2a.server.requesthandlers.RequestHandler;
import io.a2a.spec.AgentCard;
import io.a2a.transport.grpc.handler.CallContextFactory;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Initialized;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import org.wildfly.extras.a2a.server.apps.grpc.WildFlyGrpcHandler;

@ApplicationScoped
public class GrpcBeanInitializer {
    @Inject
    @PublicAgentCard
    AgentCard agentCard;
    @Inject
    RequestHandler requestHandler;
    @Inject
    Instance<CallContextFactory> callContextFactory;

    public void onStartup(@Observes @Initialized(value=ApplicationScoped.class) Object init) {
        System.out.println("*** GrpcBeanInitializer.onStartup() called - ApplicationScoped initialized ***");
        try {
            CallContextFactory ccf = this.callContextFactory.isUnsatisfied() ? null : (CallContextFactory)this.callContextFactory.get();
            WildFlyGrpcHandler.setStaticBeans(this.agentCard, this.requestHandler, ccf);
            System.out.println("*** GrpcBeanInitializer successfully cached beans: agentCard=" + String.valueOf(this.agentCard) + ", requestHandler=" + String.valueOf(this.requestHandler) + ", callContextFactory=" + String.valueOf(ccf) + " ***");
        }
        catch (Exception e) {
            System.err.println("*** GrpcBeanInitializer.onStartup() failed: " + e.getMessage());
            e.printStackTrace();
        }
    }

    @PreDestroy
    public void cleanup() {
        WildFlyGrpcHandler.setStaticBeans(null, null, null);
    }
}

