/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.a2a.server.apps.grpc;

import io.a2a.server.PublicAgentCard;
import io.a2a.server.requesthandlers.RequestHandler;
import io.a2a.server.util.async.Internal;
import io.a2a.spec.AgentCard;
import io.a2a.transport.grpc.handler.CallContextFactory;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Initialized;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.util.concurrent.Executor;
import org.wildfly.extras.a2a.server.apps.grpc.WildFlyGrpcHandler;

@ApplicationScoped
public class GrpcBeanInitializer {
    @Inject
    @PublicAgentCard
    AgentCard agentCard;
    @Inject
    RequestHandler requestHandler;
    @Inject
    Instance<CallContextFactory> callContextFactory;
    @Inject
    @Internal
    Executor executor;

    public void onStartup(@Observes @Initialized(value=ApplicationScoped.class) Object init) {
        try {
            CallContextFactory ccf = this.callContextFactory.isUnsatisfied() ? null : (CallContextFactory)this.callContextFactory.get();
            WildFlyGrpcHandler.setStaticBeans(this.agentCard, this.requestHandler, ccf, this.executor);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @PreDestroy
    public void cleanup() {
        WildFlyGrpcHandler.setStaticBeans(null, null, null, null);
    }
}

