/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.a2a.server.apps.jakarta;

import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.PreMatching;
import jakarta.ws.rs.ext.Provider;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@PreMatching
public class A2ARequestFilter
implements ContainerRequestFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(A2ARequestFilter.class);

    public void filter(ContainerRequestContext requestContext) {
        if (this.isA2ARequest(requestContext)) {
            try (InputStream entityInputStream = requestContext.getEntityStream();){
                byte[] requestBodyBytes = entityInputStream.readAllBytes();
                String requestBody = new String(requestBodyBytes);
                if (A2ARequestFilter.isStreamingRequest(requestBody)) {
                    LOGGER.debug("Handling request as streaming: {}", (Object)requestBody);
                    A2ARequestFilter.putAcceptHeader(requestContext, "text/event-stream");
                } else if (A2ARequestFilter.isNonStreamingRequest(requestBody)) {
                    LOGGER.debug("Handling request as non-streaming: {}", (Object)requestBody);
                    A2ARequestFilter.putAcceptHeader(requestContext, "application/json");
                }
                requestContext.setEntityStream((InputStream)new ByteArrayInputStream(requestBodyBytes));
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to read the request body");
            }
        }
    }

    private boolean isA2ARequest(ContainerRequestContext requestContext) {
        String path = requestContext.getUriInfo().getPath().trim();
        if (path.equals("/") || path.startsWith("/agent/") || path.startsWith("/.well-known/")) {
            return requestContext.getMethod().equals("POST") && requestContext.hasEntity();
        }
        return false;
    }

    private static boolean isStreamingRequest(String requestBody) {
        return requestBody.contains("message/stream") || requestBody.contains("tasks/resubscribe");
    }

    private static boolean isNonStreamingRequest(String requestBody) {
        return requestBody.contains("tasks/get") || requestBody.contains("tasks/cancel") || requestBody.contains("message/send") || requestBody.contains("tasks/pushNotificationConfig/set") || requestBody.contains("tasks/pushNotificationConfig/get") || requestBody.contains("tasks/pushNotificationConfig/list") || requestBody.contains("tasks/pushNotificationConfig/delete") || requestBody.contains("agent/getAuthenticatedExtendedCard");
    }

    private static void putAcceptHeader(ContainerRequestContext requestContext, String mediaType) {
        requestContext.getHeaders().putSingle((Object)"Accept", (Object)mediaType);
    }
}

