/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.a2a.server.apps.rest;

import java.io.PrintWriter;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SSESubscriber
implements Flow.Subscriber<String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SSESubscriber.class);
    private static volatile Runnable streamingIsSubscribedRunnable;
    private Flow.Subscription subscription;
    private final AtomicLong eventId = new AtomicLong(0L);
    private final CompletableFuture<Void> streamingComplete;
    private final PrintWriter writer;

    public SSESubscriber(CompletableFuture<Void> streamingComplete, PrintWriter writer) {
        this.streamingComplete = streamingComplete;
        this.writer = writer;
    }

    public static void setStreamingIsSubscribedRunnable(Runnable streamingIsSubscribedRunnable) {
        SSESubscriber.streamingIsSubscribedRunnable = streamingIsSubscribedRunnable;
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        LOGGER.debug("Custom SSE subscriber onSubscribe called");
        this.subscription = subscription;
        subscription.request(Long.MAX_VALUE);
        Runnable runnable = streamingIsSubscribedRunnable;
        if (runnable != null) {
            runnable.run();
        }
    }

    @Override
    public void onNext(String item) {
        LOGGER.debug("Custom SSE subscriber onNext called with item: {}", (Object)item);
        try {
            long id = this.eventId.getAndIncrement();
            this.writer.write("data: " + item + "\n");
            this.writer.write("id: " + id + "\n");
            this.writer.write("\n");
            this.writer.flush();
            LOGGER.info("Custom SSE event sent successfully with id: {}", (Object)id);
        }
        catch (Exception e) {
            LOGGER.error("Error writing SSE event: {}", (Object)e.getMessage(), (Object)e);
            this.onError(e);
        }
    }

    @Override
    public void onError(Throwable throwable) {
        LOGGER.debug("Custom SSE subscriber onError called: {}", (Object)throwable.getMessage(), (Object)throwable);
        this.streamingComplete.completeExceptionally(throwable);
    }

    @Override
    public void onComplete() {
        LOGGER.debug("Custom SSE subscriber onComplete called");
        this.streamingComplete.complete(null);
    }
}

