/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.apigen.generator;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.logging.Logger;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.logmanager.Level;
import org.wildfly.apigen.generator.Config;
import org.wildfly.apigen.generator.GeneratorScope;
import org.wildfly.apigen.generator.GeneratorTarget;
import org.wildfly.apigen.generator.MetaDataIterator;
import org.wildfly.apigen.generator.ResourceMetaData;
import org.wildfly.apigen.generator.SourceFactory;
import org.wildfly.apigen.invocation.ClientFactory;
import org.wildfly.apigen.model.DefaultStatementContext;
import org.wildfly.apigen.model.ResourceDescription;
import org.wildfly.apigen.operations.ReadDescription;

public class Generator {
    private static ModelControllerClient client;
    private static final Logger log;
    private final String targetDir;
    private final Config config;

    public Generator(String targetDir, Config config) {
        this.targetDir = targetDir;
        this.config = config;
        try {
            client = ClientFactory.createClient(config);
        }
        catch (Exception e) {
            log.log((java.util.logging.Level)Level.ERROR, "Failed to create model controller client", e);
        }
    }

    public static void main(String[] args) throws Exception {
        log.info("Config: " + args[0]);
        log.info("Output: " + args[1]);
        Config config = Config.fromJson(args[0]);
        Generator generator = new Generator(args[1], config);
        generator.processGeneratorTargets();
        generator.shutdown();
    }

    private void shutdown() {
        try {
            client.close();
        }
        catch (IOException e) {
            log.severe(e.getMessage());
        }
    }

    public void processGeneratorTargets() {
        this.config.getGeneratorTargets().forEach(target -> {
            try {
                GeneratorScope scope = new GeneratorScope();
                ResourceMetaData resourceMetaData = Generator.fetchMetaData(target);
                resourceMetaData.set(ResourceMetaData.PKG, target.getTargetPackage());
                Iterator<ResourceMetaData> iterator = new MetaDataIterator(resourceMetaData).createInstance();
                iterator.forEachRemaining(metaData -> this.generate(scope, (ResourceMetaData)metaData, this.targetDir));
            }
            catch (Exception e) {
                log.log((java.util.logging.Level)Level.ERROR, "Failed to process targets", e);
            }
        });
    }

    private static ResourceMetaData fetchMetaData(GeneratorTarget generatorTarget) throws Exception {
        ReadDescription op = new ReadDescription(generatorTarget.getSourceAddress());
        ModelNode response = client.execute(op.resolve(new DefaultStatementContext()));
        return new ResourceMetaData(generatorTarget.getSourceAddress(), ResourceDescription.from(response));
    }

    private void generate(GeneratorScope scope, ResourceMetaData resourceMetaData, String targetDir) {
        JavaClassSource javaClass = SourceFactory.createResourceAsClass(resourceMetaData);
        SourceFactory.createChildAccessors(scope, resourceMetaData, javaClass);
        this.writeClass(targetDir, javaClass);
        scope.addGenerated(resourceMetaData.getAddress(), javaClass);
    }

    private void writeClass(String targetDir, JavaClassSource javaClass) {
        try {
            targetDir = targetDir + File.separator + javaClass.getPackage().replace(".", File.separator);
            Files.createDirectories(Paths.get(targetDir, new String[0]), new FileAttribute[0]);
            Path fileName = Paths.get(targetDir + File.separator + javaClass.getName() + ".java", new String[0]);
            log.info(javaClass.getCanonicalName());
            Files.write(fileName, javaClass.toString().getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            log.log((java.util.logging.Level)Level.ERROR, "Failed to persist class", e);
        }
    }

    static {
        log = Logger.getLogger(Generator.class.getName());
    }
}

