/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.apigen.generator;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.wildfly.apigen.generator.ResourceMetaData;
import org.wildfly.apigen.model.AddressTemplate;
import org.wildfly.apigen.model.ResourceDescription;

public class MetaDataIterator {
    private final LinkedList<ResourceMetaData> children;
    private final ResourceMetaData rootMetaData;

    public MetaDataIterator(final ResourceMetaData rootMetaData) {
        this.rootMetaData = rootMetaData;
        this.children = new LinkedList();
        this.dfs(rootMetaData.getAddress(), rootMetaData.getDescription(), new Applicable(){

            @Override
            public void apply(AddressTemplate address, ResourceDescription desc) {
                ResourceMetaData child = new ResourceMetaData(address, desc);
                child.setAll(rootMetaData.getAll());
                MetaDataIterator.this.children.add(child);
            }
        });
        Collections.sort(this.children);
    }

    private void dfs(AddressTemplate addresss, ResourceDescription root, Applicable applicable) {
        if (root == null) {
            return;
        }
        applicable.apply(addresss, root);
        if (root.hasChildrenDefined()) {
            Set<String> childrenNames = root.getChildrenNames();
            for (String childrenName : childrenNames) {
                this.dfs(addresss.append(childrenName + "=*"), root.getChildDescription(childrenName), applicable);
            }
        }
    }

    public Iterator<ResourceMetaData> createInstance() {
        return this.children.iterator();
    }

    static interface Applicable {
        public void apply(AddressTemplate var1, ResourceDescription var2);
    }
}

